

#ifndef __HM_CONFIG_H__
#define __HM_CONFIG_H__

#include "mbed.h"
#include "ble/BLE.h"
#include "ble/DiscoveredCharacteristic.h"
#include "ble/DiscoveredService.h"
#include "ble/Gap.h"

#define MAX_SERVICES 4
//class Magic_Light{
bool write_charDiscover = false;
bool notify_charDiscover = false;
bool notify_write = true;

bool startFlag = false;
bool endFlag = false;
bool respFlag = false;

static bool connect_status;
bool charDiscover;
uint8_t pre_write_data[16];
static ble_error_t error_status;
bool serviceDiscover = true;
bool first_on=true;
int spiRX[16];
uint8_t bufferSize;
uint8_t write_data[16]; //[8] = {0x00,};//={0x56,0x00,0xff,0x00,0x00,0xf0,0xaa};
int deviceInfo[16] = {0x05,0xCE, 0x01, 0x03, 0xEF, 0x01, 0x77 };
uint8_t response_data[16];
int resp_BuffSize = 0;

void AddCharNodes(DiscoveredCharacteristic light_Characteristic);
void light_actions(int service_char[]);
void write_notifyCharacterstics();

void processSPIPacket(int SPIData[]);
void responsePacket(const uint8_t *paramsData, int length);
//public:
typedef enum light_action_e{
    TURN_OFF=0, 
    TURN_ON,
    COLOR,
    NOTIFY,
    INVAILD
}light_action;

typedef enum light_color_e{
    RED=0,
    GREEN,
    BLUE,
    YELLOW,
    CYAN,
    MAGENTA,
    MAX_COLOR
}light_color;

uint8_t lightColor[MAX_COLOR][3] = {{0xFF,0x00,0x00},{0x00,0xFF,0x00},
                                    {0x00,0x00,0xFF},{0xFF,0xFF,0x00},
                                    {0x00,0xFF,0xFF},{0xFF,0x00,0xFF}
                                   };
struct lightCharacteristic_t{
    uint8_t u_characteristicID;
    Gap::Handle_t connHandle;
    GattAttribute::Handle_t valueHandle;
    struct lightCharacteristic_t *nextChar;
};

typedef struct _serviceinfo 
{
    lightCharacteristic_t * services_Char[MAX_SERVICES];

}s_serviceInfo;

//};

#endif /* ifndef __BLE_H__ */