/************************************************************************
*                                                                       *
*                                                                       *
************************************************************************/

#include "hm_config.h"

DiscoveredCharacteristic lightCharacteristic;
DiscoveredCharacteristic notifyCharacteristic;
static s_serviceInfo lightChar = {NULL,NULL,NULL,NULL};
Serial pc(USBTX, USBRX);
void bleint();
void waitBleEvent();
void ble_actions(int spi_data);
uint8_t statusWR;
SPISlave spiSlave(P0_9, P0_11, P0_8, P0_10);


void advertisementCallback(const Gap::AdvertisementCallbackParams_t *params) {
    uint8_t con_status =0;
     //0x51 for Magic light 
    //0x5A
    
        if (params->peerAddr[0] == 0x5A){ // 0x2F for red bear1.5 /* !ALERT! Alter this filter to suit your device. */
       
           pc.printf("adv peerAddr[%02x %02x %02x %02x %02x %02x] rssi %d, isScanResponse %u, AdvertisementType %u\r\n",
           params->peerAddr[5], params->peerAddr[4], params->peerAddr[3], params->peerAddr[2], params->peerAddr[1], params->peerAddr[0],
           params->rssi, params->isScanResponse, params->type);
           pc.printf("Data Length : %d\r\n",params->advertisingDataLen);
           con_status = BLE::Instance().gap().connect(params->peerAddr, Gap::ADDR_TYPE_PUBLIC, NULL, NULL);
           pc.printf("Connection Status : %d\r\n",con_status);
           connect_status = 1;
           BLE::Instance().gap().stopScan();
           
       }else{
            printf("Not Matched your device\r\n");
            return;
        }
 }

void serviceDiscoveryCallback(const DiscoveredService *service) {
    pc.printf("Service Discovery Callback\r\n");
    if (service->getUUID().shortOrLong() == UUID::UUID_TYPE_SHORT) {
        pc.printf("S UUID-%x attrs[%u %u]\r\n", service->getUUID().getShortUUID(), service->getStartHandle(), service->getEndHandle());
    } else {
        pc.printf("S UUID-");
        const uint8_t *longUUIDBytes = service->getUUID().getBaseUUID();
        for (unsigned i = 0; i < UUID::LENGTH_OF_LONG_UUID; i++) {
            printf("%02x", longUUIDBytes[i]);
        }
        pc.printf(" attrs[%u %u]\r\n", service->getStartHandle(), service->getEndHandle());
    }
}

void characteristicDiscoveryCallback(const DiscoveredCharacteristic *characteristicP) {
    pc.printf("  C UUID-%x valueAttr[%u] props[%x]\r\n", characteristicP->getUUID().getShortUUID(), characteristicP->getValueHandle(), (uint8_t)characteristicP->getProperties().broadcast());
    
    if (characteristicP->getUUID().getShortUUID() == 0xffe9) { /* !ALERT! Alter this filter to suit your device. */
       lightCharacteristic = *characteristicP;
       pc.printf("Matched char UUID\r\n");
       printf("Conn Handle = %dand %d \r\n",characteristicP->getConnectionHandle(), lightCharacteristic.getConnectionHandle());
       printf("Value Handle = %d and %d\r\n",characteristicP->getValueHandle(),lightCharacteristic.getValueHandle());
       AddCharNodes(lightCharacteristic);
       write_charDiscover = true;
       
     }
     else if(characteristicP->getUUID().getShortUUID() == 0xffe4)
     {
        notifyCharacteristic = *characteristicP;
        notify_charDiscover = true;
        pc.printf("Matched char UUID\r\n");
        printf("Conn Handle = %dand %d \r\n",characteristicP->getConnectionHandle(), notifyCharacteristic.getConnectionHandle());
        printf("Value Handle = %d and %d\r\n",characteristicP->getValueHandle(),notifyCharacteristic.getValueHandle());
       
     }
     else {
        printf("Not Matched char UUID\r\n");
     }
     
     if(notify_charDiscover && write_charDiscover)
     {
        charDiscover = 1;
        serviceDiscover = true;
     }
}

void AddCharNodes(DiscoveredCharacteristic light_Characteristic)
{
    printf("Add Char Nodes\r\n");
    lightCharacteristic_t *ptr_temp_char;
    ptr_temp_char = lightChar.services_Char[0];

    
    if(NULL == ptr_temp_char)
    {
        ptr_temp_char = new lightCharacteristic_t;
        lightChar.services_Char[0] = ptr_temp_char;
    }
    else
    {    
        while(NULL != ptr_temp_char->nextChar)
                {
                    ptr_temp_char = ptr_temp_char->nextChar;
                }  
            
        /* add a new node */
        ptr_temp_char->nextChar = new lightCharacteristic_t;           
        ptr_temp_char = ptr_temp_char->nextChar;
    }
            
    /* assign data to the node */
    ptr_temp_char->u_characteristicID = 1;
    printf("Conn Handle = %d\r\n",light_Characteristic.getConnectionHandle());
    printf("Value Handle = %d\r\n",light_Characteristic.getValueHandle());
    ptr_temp_char->connHandle = light_Characteristic.getConnectionHandle();
    ptr_temp_char->valueHandle = light_Characteristic.getValueHandle();
    ptr_temp_char->nextChar = NULL;  
}

void discoveryTerminationCallback(Gap::Handle_t connectionHandle) {
    pc.printf("terminated SD for handle %u\r\n", connectionHandle);
    serviceDiscover = false;
}

void connectionCallback(const Gap::ConnectionCallbackParams_t *params) {
    pc.printf("Connection Callback\n\r");
    if (params->role == Gap::CENTRAL) {
        pc.printf("Service and characterstics discovery callback\r\n");
        BLE::Instance().gattClient().onServiceDiscoveryTermination(discoveryTerminationCallback);
        BLE::Instance().gattClient().launchServiceDiscovery(params->handle, serviceDiscoveryCallback, characteristicDiscoveryCallback/*, 0xffe5, 0xffe9*/);
        // 0xffe5 --> Services UUID
        // 0xffe9 --> Characteristics UUID
    }
}

void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params) {
    pc.printf("disconnected\r\n");
    BLE::Instance().gap().startScan(advertisementCallback);
}

void hvxCallback(const GattHVXCallbackParams *params) {
    printf("received HVX callback for handle %u; type %s\r\n", params->handle, (params->type == BLE_HVX_NOTIFICATION) ? "notification" : "indication");
    for (unsigned index = 0; index < params->len; index++) {
        printf(" %02x", params->data[index]);
    }
    strncpy((char *)response_data, (char *)params->data, params->len);
    resp_BuffSize = params->len;
    
    printf("\r\n");
}

/**
 * Callback triggered when the ble initialization process has finished
 */
void bleInitComplete(BLE::InitializationCompleteCallbackContext *params)
{
    BLE&        ble   = params->ble;
    
    pc.printf("Ble Init\n\r");
    /* Ensure that it is the default instance of BLE */
    if(ble.getInstanceID() != BLE::DEFAULT_INSTANCE) {
        return;
    }
 
    ble.gap().onConnection(connectionCallback);
    ble.gap().onDisconnection(disconnectionCallback);
    ble.gap().setScanParams(1000, 800);
    ble.gap().startScan(advertisementCallback);
    
    ble.gattClient().onHVX(hvxCallback);
}

void light_actions(int service_char[]){
    lightCharacteristic_t *ptr_tmp = NULL;
    ptr_tmp = lightChar.services_Char[0];
    uint8_t numCount;
    if(connect_status)
    {

        switch(service_char[1])
        {
            case TURN_OFF: // off 
                write_data[0]=0x56;
                write_data[1]=0x00;
                write_data[2]=0x00;
                write_data[3]=0x00;
                write_data[4]=0x00;
                write_data[5]=0xf0;
                write_data[6]=0xaa;
                error_status = BLE::Instance().gattClient().write(GattClient::GATT_OP_WRITE_CMD,ptr_tmp->connHandle,ptr_tmp->valueHandle,8,write_data);
                BLE::Instance().processEvents();
                break;
                       
            case TURN_ON: //on
                pre_write_data[0]=0x56;
                pre_write_data[1]=0xDE;
                pre_write_data[2]=0x8E;
                pre_write_data[3]=0xEE;
                pre_write_data[4]=0x00;
                pre_write_data[5]=0xf0;
                pre_write_data[6]=0xaa;
                
                error_status = BLE::Instance().gattClient().write(GattClient::GATT_OP_WRITE_CMD,ptr_tmp->connHandle,ptr_tmp->valueHandle,8,pre_write_data);
                BLE::Instance().processEvents();
                break;
                       
            case COLOR: // Color
                write_data[0]=0x56;
                write_data[1]=lightColor[service_char[2]][0];//0xff
                write_data[2]=lightColor[service_char[2]][1];//0x00;
                write_data[3]=lightColor[service_char[2]][2];//0x00;
                write_data[4]=0x00;
                write_data[5]=0xf0;
                write_data[6]=0xaa;
                for(numCount=0; numCount < 7; numCount++){
                  pre_write_data[numCount] = write_data[numCount];
                }
                first_on=false;
                error_status = BLE::Instance().gattClient().write(GattClient::GATT_OP_WRITE_CMD,ptr_tmp->connHandle,ptr_tmp->valueHandle,8,write_data);
                BLE::Instance().processEvents();
                break;
                
            case NOTIFY:
                //[0xEF, 0x01, 0x77] Notify Value
                write_data[0]=0xEF;
                write_data[1]=0x01;
                write_data[2]=0x77;
                error_status = BLE::Instance().gattClient().write(GattClient::GATT_OP_WRITE_CMD,ptr_tmp->connHandle,ptr_tmp->valueHandle,8,write_data);
                BLE::Instance().processEvents();
                break;
                
            default:
                printf("Invalid Options\r\n");
        } 
            printf("Error Status =%d\n\r",error_status);
    }
    
}

void write_notifyCharacterstics()
{
    printf("write_notifyCharacterstics \n\r");
    uint16_t value = BLE_HVX_NOTIFICATION;
    error_status = BLE::Instance().gattClient().write(GattClient::GATT_OP_WRITE_REQ,
                            notifyCharacteristic.getConnectionHandle(),
                            notifyCharacteristic.getValueHandle(), /* HACK Alert. We're assuming that CCCD descriptor immediately follows the value attribute. */
                            sizeof(uint16_t),                          /* HACK Alert! size should be made into a BLE_API constant. */
                            reinterpret_cast<const uint8_t *>(&value));
    printf("Conn Handle = %d \r\n",notifyCharacteristic.getConnectionHandle());
    printf("Value Handle = %d \r\n",notifyCharacteristic.getValueHandle());
       
    printf("write_notifyCharacterstics %d \n\r", error_status);                     
    BLE::Instance().processEvents();
}
void datancpy(char pre_write[], char writeData[], int data_size){
    int numCount;
    for(numCount=0; numCount <= data_size; numCount++){
        pre_write[numCount] = writeData[numCount];
    }
    
}

void bleint()
{
    printf("Init\r\n");
    BLE &ble = BLE::Instance();
    BLE::Instance().init(bleInitComplete);
}

int main()
{
    // Serial port configuration
    pc.baud(9600);
    wait(8.0);
    pc.printf("Start\n\r");

    spiSlave.reply(191);
    statusWR=1;
    bleint();
    bufferSize = 0;
    int temp = 0;
    //int index=0;
    
    //int temp = 0x00;
    //int color = 0x00;
    //int i=0;
    while(1){
        //printf("loop\r\n");
        if(!(connect_status && charDiscover))
            waitBleEvent();
            
        if(charDiscover && connect_status && notify_write ) //&& notify_write 
        {
            printf("Write Notify \n\r");
            write_notifyCharacterstics();
            notify_write = false;
            
        }
                   
        if(spiSlave.receive()){
            // printf("Slave Read loop1\r\n");

            temp = spiSlave.read();
            
            if(temp == 0x86)
            {
                bufferSize = 0;
                startFlag = true;
                endFlag = false;
                spiSlave.reply(0x86);
                
            }else if(temp == 0x88)
            {
                endFlag= true;
                spiSlave.reply(0x88);
                
            }else if(startFlag == true && endFlag == false)
            {
                spiRX[bufferSize] = temp;
                spiSlave.reply(temp);
                bufferSize++;
            }
            
            if(startFlag && endFlag)
            {
                processSPIPacket(spiRX);
                startFlag = false;
                endFlag = false;
                spiSlave.reply(0xAA);
            }
                      
            
        } 
        //wait_ms(1000);
        
        
    }

}

void waitBleEvent()
{
    while(serviceDiscover || BLE::Instance().gattClient().isServiceDiscoveryActive()){
                    BLE::Instance().waitForEvent();
    }               
}

void processSPIPacket(int SPIData[])
{
    int start_index = 2;
    int temp_buff[8];
    for(int k =0; k < SPIData[0]; k++, start_index++)
    {
        temp_buff[k] = SPIData[start_index];
        
    }
    switch(SPIData[1])
    {
        case 0xCE:
            {
                light_actions(temp_buff);
            }
            break;
        
        default:
            printf("Unknown data \r\n");
            break;
    }   

}

