#include "mbed.h"
#include "SerialEvent.h"

Serial pc(USBTX,USBRX);
SerialEvent pc1(USBTX,USBRX);
PwmOut red(p36);
PwmOut green(p5);
PwmOut blue(p34);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
DigitalOut led6(P1_0);
Timer timer;
Ticker tick1;
Ticker tick2;
Ticker tick3;
Ticker tick4;

// States
//typedef enum {ST_EIN, ST_AUS, ST_ERROR, ST_STATE1} nextState;
// alternativ
const int ST_BOOT = 0;
const int ST_AUTH = 1;
const int ST_STRING = 2;
const int ST_RECEIVE = 3;
const int ST_COMP = 4;
const int ST_SUCCESS = 5;
const int ST_FAIL = 6;
const int ST_END = 7;
char inString[STRMAX];
char stringRND[STRMAX];
char message[STRMAX];
int line= 0;
int tries= 0 ;
int poss = 0;
void blink();
void gen_random(char *s, const int len)
{
    static const char alphanum[] =
        "0123456789"
        "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
        "abcdefghijklmnopqrstuvwxyz";

    for (int i = 0; i < len; ++i) {
        s[i] = alphanum[rand() % (sizeof(alphanum) - 1)];
    }
}
////----------------------------------Ticker Klasse---------------------------------
class Blinker {
public:
    Blinker(PinName pin) : _pin(pin) {
        _pin = 0;
    }
    void blink() {
        _pin = !_pin;
    }
private:
    DigitalOut _pin;
};
Blinker t1(LED1);
Blinker t2(LED2);
Blinker t3(LED3);
Blinker t4(LED4);
// ---------------- Event Klasse --------------------------
class SwEvent
{
    InterruptIn _isr;
    bool _pressed;
    void _RisingISR();

public:
    SwEvent(PinName pin) : _isr(pin) {
        _pressed = false;
    }
    int CheckFlag();    // dies muss im do-Zweig (while(true) Schleife) ständig abgefragt werden
    void InitIsr();
};

int SwEvent::CheckFlag()
{
    if( _pressed ) {
        _pressed = false;
        return 1;
    }
    return 0;
}

void SwEvent::InitIsr()
{
    _isr.rise(this, &SwEvent::_RisingISR);
}

void SwEvent::_RisingISR()
{
    if( _isr.read() )
        _pressed = true;
}

SwEvent sw1(P0_10);

// ----------------- Stm Klasse -----------------------------
class Stm
{
public:
    Stm() {
        state=ST_BOOT;
    }

    void Boot();
    void Auth();
    void String();
    void Receive();
    void Comp();
    void Success();
    void Fail();
    void End();

    int state;
};


void Stm::Boot()
{   tick1.detach();
    tick2.detach();
    tick3.detach();
    tick4.detach();
    pc.printf("Hello\n");
    timer.start();
    while(true) {
        led1 = led2 = led3 = led4 = 0;

        if(timer.read() >= 1) {
            state = ST_AUTH;
            led1 = 1;
            timer.stop();
            timer.reset();
            return;
        }
    }
}

void Stm::Auth()
{
    
    
    pc.printf("Press Sw 2\n");
    while(true) {
        led6 = 1;
        if(sw1.CheckFlag()) {
            led6 = 0;
            state = ST_STRING;
            return;
        }
        
    }
}


void Stm::String()
{
    tick1.detach();
    tick2.detach();
    tick3.detach();
    tick4.detach();
    gen_random(stringRND,5);
    pc.printf("RND String lautet: %s \n", stringRND);
    pc.printf("Geben Sie ihn nun erneut ein: \n");
    timer.start();
    while(true) {
        led1 = 0;
        led2 = 1;

        //s[len] = 0;
        state = ST_RECEIVE;
        return;
    }
}


void Stm::Receive()
{
    tick1.detach();
    tick2.detach();
    tick3.detach();
    tick4.detach();
    //pc1.pc_recv();
    if(pc1.checkFlag()) {
        pc1.getString(inString);
        //pc1.scanf(inString);
        pc.printf("%s\n", inString);
        state = ST_COMP;
        return;

    }
}

void Stm::Comp()
{
    tick1.detach();
    tick2.detach();
    tick3.detach();
    tick4.detach();
    if(strncmp(stringRND,inString,5) == 0) {
        pc.printf("Sie haben %f Sekunden fuer Ihre Authentifikation benoetigt\n", timer.read());
        state = ST_SUCCESS;
        return;
    } else if( tries == 3) {
        state = ST_END;
        return;
    } else {
        tries++;
        poss = 4 - tries;
        pc.printf("Sie haben noch %d Moeglichkeiten, um sich richtig zu authentifizieren",poss);
        state = ST_RECEIVE;
    }
}

void Stm::Success()
{
    tick1.detach();
    tick2.detach();
    tick3.detach();
    tick4.detach();
    printf("WELCOME!");
    led1 = led2 = led3 = led4 = 1;
    //message[STRMAX] = '\0';
    while(true) {
        if(pc1.checkFlag()) {
            pc1.getString(message);
            line++;
            pc.printf("%d:%d>%s\n",line,strlen(message),message);
            if(message[0] == '.') {
                state = ST_AUTH;
                return;
            }
        }
    }
}

void Stm::Fail()
{
    tick1.detach();
    tick2.detach();
    tick3.detach();
    tick4.detach();
    while(true) {

        led1 = led3 = led4 = 0;
        led2 = 1;
        state = ST_END;
        return;
    }
}


void Stm::End()
{
        //led1 = led2 = led3 = led4 = 1;
        tick1.attach(&t1, &Blinker::blink, 0.2);
        tick2.attach(&t2, &Blinker::blink, 0.2);
        tick3.attach(&t3, &Blinker::blink, 0.2);
        tick4.attach(&t4, &Blinker::blink, 0.2);
        /*while(true){
            if(timer.read_ms()%200 == 0){
            led1 =~ led1;
            led2 =~ led2;
            led3 =~ led3;
            led4 =~ led4;
            }
            }*/  
        tries = 0;
        pc.printf("%d", timer.read());
        state = ST_AUTH;
        return;
}




Stm stm;

void stateMachine()
{
    switch (stm.state) {
        case ST_BOOT:
            stm.Boot();
            break;
        case ST_AUTH:
            stm.Auth();
            break;
        case ST_STRING:
            stm.String();
            break;
        case ST_RECEIVE:
            stm.Receive();
            break;
        case ST_COMP:
            stm.Comp();
            break;
        case ST_SUCCESS:
            stm.Success();
            break;
        case ST_FAIL:
            stm.Fail();
            break;
        case ST_END:
            stm.End();
            break;


    }
}

int main()
{
    //printf("Hello STM\n");
    sw1.InitIsr();

    red=green=1;
    while(1) {
        stateMachine();
    }
}