#include "mbed.h"

DigitalOut led(p20);//P1_13);
Serial pc(USBTX,USBRX);
BusOut leds(LED1,LED2,LED3,LED4);
Timer tim;
Ticker tick;
char strRnd[5];
char strIn[50];
int tries=0,cnt=0;

// States
const int ST_BOOT = 0;
const int ST_AUTH = 1;
const int ST_STRING = 2;
const int ST_INPUT = 3;
const int ST_COMP = 4;
const int ST_SUCC = 5;

void blink();
// ---------------- Read String from Serial --------------------------
void ReadFromSerial(char *s, const int MAX_SIZE=50)
{
    for (int i = 0; i < 50; i++) {s[i] = '\0';}    //set entire string to NULL
    for (int i = 0; i < 50; i++) {
        char c = pc.getc();
        if (c == '\n')
            break;
        s[i] = c;
    }
}
// ---------------- Random String Gen --------------------------
void gen_random(char *s, const int len)
{
    static const char alphanum[] =
        "0123456789"
        "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
        "abcdefghijklmnopqrstuvwxyz";

    for (int i = 0; i < len; ++i) {
        s[i] = alphanum[rand() % (sizeof(alphanum) - 1)];
    }

    s[len] = 0;
}
// ---------------- Event Klasse --------------------------
class SwEvent
{
    InterruptIn _isr;
    bool _pressed;
    void _RisingISR();

public:
    SwEvent(PinName pin) : _isr(pin) {
        _pressed = false;
    }
    int CheckFlag();    // das muss im do-Zweig (while(true) Schleife) ständig abgefragt werden
    void InitIsr();
};

int SwEvent::CheckFlag()
{
    if( _pressed ) {
        _pressed = false;
        return 1;
    }
    return 0;
}

void SwEvent::InitIsr()
{
    _isr.rise(this, &SwEvent::_RisingISR);
}

void SwEvent::_RisingISR()
{
    if( _isr.read() )
        _pressed = true;
}

SwEvent sw2(P0_23);

// ----------------- Stm Klasse -----------------------------
class Stm
{
public:
    Stm() {
        state=ST_BOOT;
    }

    void Boot();
    void Auth();
    void GenString();
    void Input();
    void Comp();
    void Succ();

    uint8_t state;
};


void Stm::Boot()  //ST-0 -> Boot Message
{
    leds = 0x0;
    pc.printf("HELLO!\n");
    tim.start();
    while(true) {
        if(tim.read()>1) {
            tim.stop();
            tim.reset();
            state = ST_AUTH;
            return;
        }
    }
}

void Stm::Auth()  //ST-1 -> Authentication
{
    tick.attach(&blink,0.5);
    tim.reset();
    pc.printf("Bitte betaetigen Sie die Taste <SW2> um fortzufahren\n");
    while(true) {
        led=1;
        if(sw2.CheckFlag()) {
            tick.detach();
            state = ST_STRING;
            return;
        }
    }
}

void Stm::GenString()  //ST-2 -> Generate Random String
{
    gen_random(strRnd, 5);
    pc.printf("%s\n",strRnd);
    tim.start();
    leds=0x9;
    tick.attach(&blink,0.2);
    while(1) {
        state = ST_INPUT;
        return;
    }
}


void Stm::Input()  //ST-3 -> Input from Serial
{
    pc.printf("String eingeben!\n");
    while(1) {
        strIn[0]='\0';
        //pc.scanf("%s", strIn);
        ReadFromSerial(strIn);
        pc.printf("%s\n",strIn);
        tick.detach();leds = 0x0;
        state = ST_COMP;
        return;
    }
}


void Stm::Comp()  //ST-4 -> Compare the Strings
{
    if (strncmp(strRnd,strIn,5)==0) { //Strings sind gleich
        tim.stop();
        leds=0xF;
        tries = 0;
        pc.printf("Erfolgreiche Eingabe in %.2f Sekunden\n",tim.read());
        while(1) {
            state = ST_SUCC;
            return;
        }
    } else if (strncmp(strRnd,strIn,5)!=0 && tries == 2) { //3x falsch
        tim.reset();
        tries +=1;
        pc.printf("3-fach Falsche Eingabe\n");
        leds=0xF;
        while(1) {
            if (tim.read_ms()>200) {
                leds = ~leds;
                tim.reset();
            }
        }
    } else { //falsch
        pc.printf("Falsche Eingabe\n");
        tries +=1;
        leds=0x2;
        state=ST_INPUT;
    }
}
void Stm::Succ()  //ST-5 -> Successful Input
{
    while(1) {
        ReadFromSerial(strIn);
        if (strIn[0] == '.') {
            leds = 0x0;
            state = ST_AUTH;
            return;
        }
        if (strIn[0] != '\0') {
            cnt++;
            pc.printf("%i:%i> %s\n",cnt,strlen(strIn),strIn);
        }
    }
}


Stm stm;

void stateMachine()
{
    switch (stm.state) {
        case ST_BOOT:
            stm.Boot();
            break;
        case ST_AUTH:
            stm.Auth();
            break;
        case ST_STRING:
            stm.GenString();
            break;
        case ST_INPUT:
            stm.Input();
            break;
        case ST_COMP:
            stm.Comp();
            break;
        case ST_SUCC:
            stm.Succ();
            break;
        default:
            stm.Boot();
            break;
    }
}

void blink(){
    if (stm.state == ST_AUTH){
        leds[0] = !leds[0];}
    if (stm.state == ST_INPUT){
        leds = ~leds;}
}

int main()
{
    sw2.InitIsr();
    while(1) {
        stateMachine();
    }
}
