#include "mbed.h"

PwmOut red(p36);
PwmOut green(p5); 
PwmOut blue(p34);
DigitalOut led[] = {(LED1),(LED2),(LED3),(LED4),(P1_0),(P1_1),(P1_3),(P1_4),(P1_6),(P1_7),(P1_12),(P1_13)};
DigitalIn sw1(P0_10); 
DigitalIn sw3(P0_15); 
DigitalIn sw4(P1_16); 

Serial pc(USBTX, USBRX);
Timer timer;
Ticker tick1;
Ticker tick2;
Ticker tick3;
Ticker tick4;


const uint8_t STRMAX = 20;  
const char EOT = '.';
const char CRLF = '\n';

//States
const int ST_Start = 1;
const int ST_Aut = 2;
const int ST_Eing = 3;
const int ST_Out = 4;
const int ST_Fail = 5;
const int ST_Erf = 6; 
////----------------------------------Ticker Class---------------------------------
class Blinker {
public:
    Blinker(PinName pin) : _pin(pin) {
        _pin = 0;
    }
    void blink() {
        _pin = !_pin;
    }
private:
    DigitalOut _pin;
};
Blinker t1(LED1);
Blinker t2(LED2);
Blinker t3(LED3);
Blinker t4(LED4);
//-------------------------------------Event Class --------------------------------------------
class SwEvent {
        InterruptIn _isr;
        bool _pressed;
        void _RisingISR();

    public:
        SwEvent(PinName pin) : _isr(pin) { 
            _pressed = false;
        }
        int CheckFlag();    // das muss im do-Zweig (while(true) Schleife) ständig abgefragt werden
        void InitIsr();
};
 
int SwEvent::CheckFlag() {
    if( _pressed ) { 
        _pressed = false; 
        return 1; 
    }
    return 0;
}

void SwEvent::InitIsr() { 
    _isr.rise(this, &SwEvent::_RisingISR); 
}

void SwEvent::_RisingISR() {
    if( _isr.read() )
        _pressed = true;
}

SwEvent sw2(P0_23);
int state;
// ---------------- Serial RS232 Event Class  --------------------------
class SerialEvent {
        Serial _pc;
        void _risingISR();
        char _str[STRMAX]; 
        volatile bool _strOkFlag;
        int _index;
 
 
    public:
        SerialEvent(PinName tx, PinName rx) : _pc(tx, rx) { // create the Serial on the pin specified to SwEvent
            _pc.attach(this, &SerialEvent::pc_recv);        // attach DataReceive-function of this SerialEvent instance 
            _strOkFlag = false;
            _index=0;
 
        }
        void pc_recv();
        void getString(char st[]);
        int checkFlag();                                 // must in do-condition (while(true)-loop) continuously interrogated
};
SerialEvent se(USBTX, USBRX);
// ---------------- Serial Event Class Methodes --------------------------
void SerialEvent::getString(char st[]) {
    for( int i=0; i <= _index; i++)
        st[i] = _str[i];
    _index=0;
}
 
void SerialEvent::pc_recv() {
    char c;
    while(_pc.readable()){
        c = _pc.getc();
        if((c != CRLF) && (_index < STRMAX)) {
            _str[_index++] = c;
        }
    }
    if(( c == EOT)) {           // end: . string not empty
        if(_index >= 1) {
            _strOkFlag = true;
            _str[--_index] = 0; 
        }
    }
}
 
int SerialEvent::checkFlag() {
    if( _strOkFlag ) {
        _strOkFlag = false; 
        return 1;
    }
    return 0;
}
//-----------------------------------Zufall--------------------------------------------
void gen_random(char *s, const int len) {
    static const char alphanum[] =
        "0123456789"
        "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
        "abcdefghijklmnopqrstuvwxyz";

    for (int i = 0; i < len; ++i) {
        s[i] = alphanum[rand() % (sizeof(alphanum) - 1)];
    }

    s[len] = 0;
}
//-----------------------------------STM class------------------------------------------
 
class STM {
public:
 int fails;
    STM() {state = ST_Start;
            fails=0;}
   void start();
    void auforderung();
    void eingabe();
    void timeout();
    void fail();
    void erfolg();
   
};
void STM::start()
{
 //entry
 //do
    tick1.detach();
    tick2.detach();
    tick3.detach();
    tick4.detach();
    led[0]=0;
    led[1]=0;
    led[2]=0;
    led[3]=0;
    tick1.attach(&t1, &Blinker::blink, 1.0);
    pc.printf("Das ist ein Begruesungstext -Hallo-\n");
    pc.printf("Bitte Taste 2 druecken um zu Authentifizieren\n");
 //exit
    state = ST_Aut;
 }
void STM::auforderung()
{
 //entry
    while(true){
        led[7] = 1;
        if(sw2.CheckFlag()){
            led[7]=0;
            tick1.detach();
            tick2.detach();
            tick3.detach();
            tick4.detach();
            led[0]=0;
            led[1]=0;
            led[2]=0;
            led[3]=0;
            tick2.attach(&t2, &Blinker::blink, 0.2);
            state = ST_Eing;
            return;
         }
        }
 //do
 //exit
 }
 void STM::eingabe()
{
 //entry
  char ghash[27];
  char ehash[27];
  bool equal=false;
 //do
    pc.printf("Geben sie diesen Hash ein\n");
    gen_random(ghash, 5);
    pc.printf("%s\n",ghash);
    timer.start();
    while(true){
        if(se.checkFlag()){
            se.getString(ehash);
            //pc.printf("%s\n",ehash);
            equal = !strcmp(ehash,ghash);
              if(fails==3){   
                    state= ST_Out;
                    return;
                }
                if (equal){
                    state= ST_Erf;
                    return;
                    }
                else{
                    state= ST_Fail;
                    return;
                }
            }
        }
 //exit
 }
 void STM::timeout()
{
 //entry
    tick1.detach();
    tick2.detach();
    tick3.detach();
    tick4.detach();
    led[0]=0;
        led[1]=0;
        led[2]=0;
        led[3]=0;
        fails=0;
 //do
    timer.stop();
    pc.printf("Nach %f sind die versucheabgelaufen\n", timer.read());
    tick1.attach(&t1, &Blinker::blink, 0.2);
    tick2.attach(&t2, &Blinker::blink, 0.2);
    tick3.attach(&t3, &Blinker::blink, 0.2);
    tick4.attach(&t4, &Blinker::blink, 0.2);
 //exit
    state =ST_Aut;
    pc.printf("Bitte Taste 2 druecken um zu Authentifizieren\n");
 }
 void STM::fail()
{
 //entry
    tick1.detach();
    tick2.detach();
    tick3.detach();
    tick4.detach();
    led[0]=0;
        led[1]=0;
        led[2]=0;
        led[3]=0;
 //do
    tick1.attach(&t1, &Blinker::blink, 0.1);
    tick2.attach(&t2, &Blinker::blink, 0.1);
    tick3.attach(&t3, &Blinker::blink, 0.1);
    tick4.attach(&t4, &Blinker::blink, 0.1);
    fails+=1;
 //exit
    state = ST_Eing;
 }
 void STM::erfolg()
{
 //entry
    tick1.detach();
    tick2.detach();
    tick3.detach();
    tick4.detach();
    led[0]=0;
        led[1]=0;
        led[2]=0;
        led[3]=0;
    char text[27];
    int Nr=0;
    int length=0;
    char nix;
    fails = 0;
 //do
    timer.stop();
        pc.printf("Nach %fs wurde eien erfolgreiche Enigabe volzogen\n", timer.read());
        led[0]=1;
        led[1]=1;
        led[2]=1;
        led[3]=1;
        timer.reset();
        while(true){
        if(se.checkFlag()){
            se.getString(text);
            if(!strcmp(text,""))
            {
                state = ST_Aut;
                led[0]=0;
                led[1]=0;
                led[2]=0;
                led[3]=0;
                return;
                }
            Nr+=1;
            length=strlen(text);
            pc.printf("%i:%i>%s\n",Nr, length, text);
            length=0;
            }
        }

 //exit
 }
 //---------------------------------------Hauptprogramm-----------------------------

STM stm;
 
 void stateMachine(){
     switch(state)
     {
         case ST_Start: stm.start();
         break;
         case ST_Aut: stm.auforderung();
         break;
         case ST_Eing: stm.eingabe();
         break;
         case ST_Out: stm.timeout();
         break;
         case ST_Fail: stm.fail();
         break;
         case ST_Erf: stm.erfolg();
         break;
         }
}

int main() {
    sw2.InitIsr();
    while(1) {
        stateMachine();
    }
}
