#include "mbed.h"
#include "HEPTA_CDH.h"
#include "HEPTA_EPS.h"
#include "HEPTA_SENSOR.h"
#include "HEPTA_COM.h"
DigitalOut cond[]={LED1,LED2,LED3,LED4};
Serial sat(USBTX,USBRX); //for satellite condition
HEPTA_CDH cdh(p5, p6, p7, p8, "sd");
HEPTA_EPS eps(p16,p26);
HEPTA_SENSOR sensor(p17,
                    p28,p27,0xD0,0x18,
                    p13,p14,p25,p24);
HEPTA_COM gs(p9,p10); //for ground station
int rcmd = 0,cmdflag = 0; //command variable
 
//getting command and flag
void commandget()
{
    rcmd=gs.getc();
    cmdflag = 1;
}
//interrupting 
void receive(int rcmd, int cmdflag)
{
    gs.xbee.attach(commandget,Serial::RxIrq);
}
//initialzing
void initialize()
{
    rcmd = 0;
    cmdflag = 0;
    cond[0] = 0;
}
int main() {
    gs.baud(9600);
    float sattime=0.0,btvol,temp;
    float ax,ay,az;
    float gx,gy,gz;
    float mx,my,mz;
    int quality=0,stnum=0,gps_check=0;
    char ns='A',ew='B',aunit='m';
    float time=0.0,latitude=0.0,longitude=0.0,hacu=0.0,altitude=0.0;
    int flag = 0;            // condition
    receive(rcmd,cmdflag); //interupting by ground station command
    
    gs.printf("From Sat : Operation Start...\r\n");   
    for(int i = 0; i < 100; i++) {
        //Sensing and Transmitting HK data , Power Saving Mode
        eps.power_saving_mode(&flag,&btvol);
        sensor.temp_sense(&temp);
        gs.printf("HEPTASAT::Condition = %d, Time = %f [s], BatVol = %.2f [V],Temp = %.2f [C]\r\n",flag,sattime,btvol,temp);
        //Condition
        cond[0] = 1;
        //Warning the status of temperature and battery voltage
        if(flag == 1) {
            gs.printf("Low Battery\r\n");
        } else if(temp > 35.0) {
            gs.printf("High temperature\r\n");
        } else if((flag == 1) & (temp > 35.0)) {
            gs.printf("Low Battery and High temperature\n");
        }
        //Contents of command
        if (cmdflag == 1) {
            if (rcmd == 'a') {
               for(int j=0;j<5;j++){
                gs.printf("HEPTASAT::Hello World!\r\n");
                cond[0] = 0;
                wait(1);
                cond[0] = 1;
               }
            }
            if (rcmd == 'b') {
                char str[100];
                mkdir("/sd/mydir", 0777);
                FILE *fp = fopen("/sd/mydir/test.txt","w");
                if(fp == NULL) {
                    error("Could not open file for write\r\n");
                }
                else
                {
                    for(int i = 0; i < 10; i++) {
                        eps.vol(&btvol);
                        fprintf(fp,"%f\r\n",btvol);
                        wait(1.0);
                    }
                    fclose(fp);
                    fp = fopen("/sd/mydir/test.txt","r");
                    for(int j = 0; j < 10; j++) {
                        fgets(str,100,fp);
                        gs.printf("%s",str);
                    }
                    fclose(fp);
                }
                cond[0] = 0;
                wait(1);
                cond[0] = 1;                  
            }
            if (rcmd == 'c') {        
                sensor.temp_sense(&temp);
                sensor.sen_gyro(&gx,&gy,&gz);
                sensor.sen_acc(&ax,&ay,&az);
                sensor.sen_mag(&mx,&my,&mz);
                sensor.gga_sensing(&time,&latitude,&ns,&longitude,&ew,&quality,&stnum,&hacu,&altitude,&aunit,&gps_check);
                gs.printf("temp=%f\r\n",temp);
                gs.printf("gx=%f,gy=%f,gz=%f\r\n",gx,gy,gz);
                gs.printf("ax=%f,ay=%f,az=%f\r\n",ax,ay,az);
                gs.printf("mx=%f,my=%f,mz=%f\r\n",mx,my,mz);
                gs.printf("latitude=%f, longtitude=%f, altitude%f\r\n",latitude,longitude,altitude);
                cond[0] = 0;
                wait(1);
                cond[0] = 1;    
            }
            if (rcmd == 'd') {
                gs.printf("Start to take a picture\r\n");
                sensor.Sync();
                sensor.initialize(HeptaCamera_GPS::Baud115200, HeptaCamera_GPS::JpegResolution320x240);
                gs.printf("[ OK ]:Picture taken\r\n");
                sensor.test_jpeg_snapshot_picture("/sd/MissionData/picture.jpg");
                gs.printf("Finish saving in SD\r\n");
                cond[0] = 0;
                wait(1);
                cond[0] = 1; 
            }
            if (rcmd == 'e') {
                // Please enter your answer in this part
                
                
                
                
                
            }
            initialize();
        }
        
        //Operation Interval
        wait(1.0);
        sattime = sattime+1.0;
    }
    gs.printf("From Sat : Operation Stop...\r\n");
}
