#include "mbed.h"
#include "HEPTA_CDH.h"
#include "HEPTA_EPS.h"
#include "HEPTA_SENSOR.h"
DigitalOut cond[]={LED1,LED2,LED3,LED4};
Serial gs(USBTX,USBRX); // for ground station
HEPTA_CDH cdh(p5, p6, p7, p8, "sd");
HEPTA_EPS eps(p16,p26);
HEPTA_SENSOR sensor(p17,
                    p28,p27,0xD0,0x18,
                    p13,p14,p25,p24);
int rcmd = 0,cmdflag = 0; //command variable
 
//getting command and flag
void commandget()
{
    rcmd=gs.getc();
    cmdflag = 1;
}
//interrupting 
void receive(int rcmd, int cmdflag)
{
    gs.attach(commandget,Serial::RxIrq);
}
//initialzing
void initialize()
{
    rcmd = 0;
    cmdflag = 0;
    cond[0] = 0;
}

int main() {
    gs.baud(9600);
    float sattime=0.0,btvol,temp;
    char str[100];
    float ax,ay,az;
    float gx,gy,gz;
    float mx,my,mz;
    int quality=0,stnum=0,gps_check=0;
    char ns='A',ew='B',aunit='m';
    float latitude=0.0,longitude=0.0,hacu=0.0,altitude=0.0;
    int flag = 0;            // condition
    receive(rcmd,cmdflag); //interupting by ground station command
    
    gs.printf("From Sat : Operation Start...\r\n");   
    for(int i = 0; i < 100; i++) {
        //Sensing and Transmitting HK data , Power Saving Mode
        eps.power_saving_mode(&flag,&btvol);
        sensor.temp_sense(&temp);
        gs.printf("HEPTASAT::Condition = %d, Time = %f [s], BatVol = %.2f [V],Temp = %.2f [C]\r\n",flag,sattime,btvol,temp);
        
        //Condition
        cond[0] = 1;
        
        //Warning the status of temperature and battery voltage
        if((flag == 1) & (temp > 35.0)) {
            gs.printf("Low Battery and High temperature\n");
        } else if(temp > 35.0) {
            gs.printf("High temperature\r\n");
        } else if(flag == 1) {
            gs.printf("Low Battery\r\n");
        }
        
        //Contents of command
        if (cmdflag == 1) {
            if (rcmd == 'a') {
               for(int j=0;j<5;j++){
                gs.printf("HEPTASAT::Hello World!\r\n");
                cond[0] = 0;
                wait(1);
                cond[0] = 1;
               }
            }
            if (rcmd == 'b') {
                char str[100];
                mkdir("/sd/mydir", 0777);
                FILE *fp = fopen("/sd/mydir/test.txt","w");
                if(fp == NULL) {
                    error("Could not open file for write\r\n");
                }
                else
                {
                    for(int i = 0; i < 10; i++) {
                        eps.vol(&btvol);
                        fprintf(fp,"%f\r\n",btvol);
                        wait(1.0);
                    }
                    fclose(fp);
                    fp = fopen("/sd/mydir/test.txt","r");
                    for(int j = 0; j < 10; j++) {
                        fgets(str,100,fp);
                        puts(str);
                    }
                    fclose(fp);
                }
                cond[0] = 0;
                wait(1);
                cond[0] = 1;                  
            }
            if (rcmd == 'c') {
                
                
                
                
            }
            if (rcmd == 'd') {
                
                
                
                
            }
            initialize();
        }
        
        //Operation Interval
        wait(1.0);
        sattime = sattime+1.0;
    }
    gs.printf("From Sat : Operation Stop...\r\n");
}