#include "mbed.h"

DigitalOut cond[]={LED1,LED2,LED3,LED4};
Serial gs(USBTX,USBRX); // for ground station
int rcmd = 0,cmdflag = 0; //command variable
 
//getting command and flag
void commandget()
{
    rcmd=gs.getc();
    cmdflag = 1;
}
//interrupting 
void receive(int rcmd, int cmdflag)
{
    gs.attach(commandget,Serial::RxIrq);
}
//initialzing
void initialize()
{
    rcmd = 0;
    cmdflag = 0;
    cond[0] = 0;
}

int main() {
    gs.baud(9600);
    gs.printf("From Sat : Operation Start...\r\n");
    int flag = 0;     // condition
    float sattime=0.0,btvol,temp; //Voltage, Temerature
    receive(rcmd,cmdflag); //interupting by ground station command
    for(int i=0; i<100; i++){
        //Sensing HK data(dummy)
        btvol = 3.7;
        temp = 28.5;
        
        //Transmitting HK data
        gs.printf("HEPTASAT::Condition = %d, Time = %f [s], batVol = %.2f [V],Temp = %.2f [C]\r\n",flag,sattime,btvol,temp);
        
        //Condition
        cond[0] = 1;
        
        //Contents of command
        if (cmdflag == 1) {
            if (rcmd == 'a') {
               for(int j=0;j<5;j++){
                gs.printf("HEPTASAT::Hello World!\r\n");
                cond[0] = 0;
                wait(1);
                cond[0] = 1;
               }
            }
            initialize();
        }
        
        //Operation Interval
        wait(1.0);
        sattime = sattime+1.0;
    }
    gs.printf("From Sat : Operation Stop...\r\n");
}