#include "mbed.h"
#include "HEPTA_EPS.h"
#include "HEPTA_CDH.h"
#include "HEPTA_SENSOR.h"
#include "HEPTA_COM.h"
#include "LPS.h" //library for pressure sensor

HEPTA_CDH cdh(PB_5, PB_4, PB_3, PA_8, "sd");
HEPTA_EPS eps(PA_0,PA_4);
HEPTA_SENSOR sensor(PA_7,PB_7,PB_6,0xD0);
HEPTA_COM com(PA_9,PA_10,9600);
DigitalOut condition(PB_1);
DigitalOut analog_switch(PA_3);
Serial sat(USBTX,USBRX, 9600);
I2C i2c(PB_7, PB_6);     //i2c for pressure sensor
LPS ps(i2c);
DigitalOut sp1(PA_1);    //DigitalOut for buzzer
Timer sattime;           
Ticker hk;
Ticker sound;
int flag = 0;            //condition flag
float batvol, temp;      //voltage, temperature 
int rcmd=0,cmdflag=0;    //command variable
int i, count;
float pressure = 0.0, altitude = 0.0;
float ax,ay,az,gx,gy,gz;
int s = 0;

#define mC 261.626
#define mD 293.665
#define mE 329.628
#define mF 349.228
#define mG 391.995
#define mA 440.000
#define mB 493.883
float mm[]={mC*4,mD*4,mE*4,mF*4,mG*4,mA*4,mB*4,mC*8};   //timbre

// 
void tick(void)
{
    sp1.write(s);
    s=!s;
}

// downlink HK dsta function
void hk_sensing() {
    com.printf("HEPTASAT::Time = %.4f [s], batvol = %.4f [V], temp = %.4f [deg C], altitude = %.4f [m]\r\n",sattime.read(),batvol,temp,altitude);
    com.printf("        ::ax = %.4f, ay = %.4f, az = %.4f, gx = %.4f, gy = %.4f, gz = %.4f\r\n",ax,ay,az,gx,gy,gz);   
    
}

int main()
{
    sat.printf("From Sat : Nominal Operation\r\n");
    com.printf("From Sat : Nominal Operation\r\n");
    sattime.start();         // start sat timer
    eps.turn_on_regulator(); //turn on 3.3V conveter  
    analog_switch = 1;       //turn on analog switch (transceiver mode)
    
    // check saving to SD card
    mkdir("/sd/mydir", 0777);
    FILE *fp = fopen("/sd/mydir/sdtest.csv", "w");
    if(fp == NULL) {
        error("Could not open file for write\r\n");
    }
    fclose(fp);
    
    // setting the pressure sensor 
        // initialize the pressure sensor 
    if (!ps.init()){
        printf("Failed to autodetect pressure sensor!\r\n");
        while (1);
    }
    ps.init();
    ps.enableDefault();
    
    while(1){
        com.initialize();        // communication system initialize
        FILE *fp = fopen("/sd/mydir/sdtest.csv", "a");
        hk.attach(&hk_sensing, 1.0); // Start the Ticker
        for(count=0; count<10; count++){
            condition = !condition;                 // LED blinking
            eps.vol(&batvol);                       // Get battery voltage
            sensor.temp_sense(&temp);               // Get temperature
            sensor.sen_acc(&ax,&ay,&az);            // Get acceleration
            sensor.sen_gyro(&gx,&gy,&gz);           // Get gyro
            pressure = ps.readPressureMillibars();  // Get pressure
            altitude = ps.pressureToAltitudeMeters(pressure);   // Get altitude
            // add HK data to file
            fprintf(fp,"%f, %f, %f, %f, %f, %f, %f, %f, %f, %f, %f\r\n",sattime.read(),batvol,temp,pressure,altitude,ax,ay,az,gx,gy,gz);
            wait_ms(100);
        }
        fclose(fp);     // save the file
        if(sattime > 300){
            //sound on
            for(i=0;i < sizeof(mm)/sizeof(mm[0]);i++) {
                sound.attach(&tick,1.0/mm[i]/2.0);  
                wait(0.5f);
            }
            sound.detach();
        }
    }
}
