"""
 
Build programs in this project
 
"""
import os, errno
 
 
def build_program(args):
    path = os.getcwd()
    parent_path = os.sep.join(path.split(os.sep)[:-1])
    odir = " --destdir " + parent_path + "\\output\\"

    mbeduser = " --user sam_grove"
    preprocessor = " --extra_symbols" + " THREE"
    
    string = "python ./mbed-API-helper/mbedapi.py  --repo http://mbed.org/teams/HDK-Development/code/CMSIS-DAP/ --api http://mbed.org --platform FRDM-KL05Z"
    string += odir
    string += mbeduser
    string += preprocessor
    
    try:
        os.makedirs(parent_path)
    except OSError, e:
        if e.errno != errno.EEXIST:
            raise
            
    #print string
    os.system(string)
      
 
if __name__ == "__main__":
    import argparse
    parser = argparse.ArgumentParser(description='configure a mbed repository build.')
    parser.add_argument('--username', type=str, help='What is your mbed username', required=False)
    parser.add_argument('--odir', type=str, help='Where does the output go', required=False)
    
    args = parser.parse_args()
    build_program(args)
    
    