#include "mbed.h"
#include "LSM9DS1.h"
#include "LPS.h"

Serial pc(USBTX, USBRX);
//Serial twelite(PE_8, PE_7);

I2C i2c(PB_9, PB_8);
LSM9DS1 lsm(i2c);
LPS lps(i2c);

//test code

int main()
{
    pc.baud(38400);
    //enum gyro_scale gs;
    //gs245 = G_SCALE_245DPS;
    uint16_t reg = lsm.begin(lsm.G_SCALE_245DPS, lsm.A_SCALE_8G);
    //printf("%x\n", reg);
    if (!lps.init()){
        while (1)
        {
            pc.printf("Failed to autodetect pressure sensor!\r\n");
            wait(2);
        };
    }
    lps.enableDefault();
    wait_ms(100);
    while(true)
    {
        lsm.readAccel();
        lsm.readMag();
        lsm.readGyro();
        //printf("%f %f %f %f %f %f %f %f %f\n", lsm.ax, lsm.ay, lsm.az, lsm.gx, lsm.gy, lsm.gz, lsm.mx, lsm.my, lsm.mz);
        //printf("%f %f %f\n", lsm.gx, lsm.gy, lsm.gz);
        //printf("%f %f %f\n", lsm.mx, lsm.my, lsm.mz);
        float pressure = lps.readPressureMillibars();
        float altitude = lps.pressureToAltitudeMeters(pressure);
        float temperature = lps.readTemperatureC();
        //printf("p:%.2f\t mbar\ta:%.2f m\tt:%.2f deg C\r\n",pressure,altitude,temperature);
        pc.printf("%f %f %f %f %f %f %f %f %f %f\r\n", lsm.ax, lsm.ay, lsm.az, lsm.gx, lsm.gy, lsm.gz, lsm.mx, lsm.my, lsm.mz,altitude);
        wait(0.1);
    }
}