#include "mbed.h"
#include "PMW3901.h"
#include "VL53L0X.h"
 
Serial pc(USBTX, USBRX); // tx, rx
//SPI spi(PB_5, PB_4, PB_3); // mosi, miso, sclk
//DigitalOut cs(PA_4); 
 
int main()
{
    pc.baud(38400);
    
    PMW3901 pmw(PB_5, PB_4, PB_3, PA_4);
    VL53L0X vl(PB_9, PB_8);
    
    int init_pmw =  pmw.init();
    int init_vl = vl.init();
    
    pc.printf("initialize pmw: %d\r\n", init_pmw);
    pc.printf("initialize vl: %d\r\n", init_vl);
    
    while (true)
    {
        pmw.read();
        vl.read();
        
        pc.printf("%f %f %f\r\n", pmw.px, pmw.py, vl.d);
        
        wait(0.01);
    }
}