#include "global.hpp"

void getHilIMUval()
{
        switch(vp.commandIndex){
        case 1:
            NVIC_SystemReset();
            break;
        case 2:
            hilDataOut = vp.commandVal;
            break;
        default : 
            break;
        }
    
    
    lsm.readAccel();
    lsm.readMag();
    lsm.readGyro();
    
    float accmx = lsm.ax * 9.8f - agoffset[0];
    float accmy = lsm.ay * 9.8f - agoffset[1];
    float accmz = lsm.az * 9.8f - agoffset[2];
    float gyromx = (lsm.gx * M_PI_F / 180.0f) - agoffset[3];
    float gyromy = (lsm.gy * M_PI_F / 180.0f) - agoffset[4];
    float gyromz = (lsm.gz * M_PI_F / 180.0f) - agoffset[5];      
    
    // gx gy gz ax ay az
    // 加速度値を分解能で割って加速度(m/s^2)に変換する
    acc(0) = 9.8f*float(vp.accData[0]) / 4096.0f + accmx;  //FS_SEL_0 16,384 LSB / g
    acc(1) = 9.8f*float(vp.accData[1]) / 4096.0f + accmy;
    acc(2) = 9.8f*float(vp.accData[2]) / 4096.0f + accmy;
    
    // 角速度値を分解能で割って角速度(rad per sec)に変換する
    gyro(0) = float(vp.gyroData[0]) / 131.0f * 0.0174533f + gyromx;  // (rad/s)
    gyro(1) = float(vp.gyroData[1]) / 131.0f * 0.0174533f + gyromy;
    gyro(2) = float(vp.gyroData[2]) / 131.0f * 0.0174533f + gyromz;
    
    Vector3f magraw;
    magraw(0) = float(vp.magData[0])/1000.0f + (lsm.mx-magref(0));
    magraw(1) = float(vp.magData[1])/1000.0f + (lsm.my-magref(1));
    magraw(2) = float(vp.magData[2])/1000.0f + (lsm.mz-magref(2));

    Vector3f magmod = magraw;
    mag(0) = magmod(0);
    mag(1) = magmod(1);
    mag(2) = magmod(2);
    
    palt =  float(vp.piData[2])/1.0f -(lps.pressureToAltitudeMeters(lps.readPressureMillibars())-palt0);;
    
    if(abs(vp.accData[0])<0.0001f && abs(vp.accData[1])<0.0001f && abs(vp.accData[2])<0.0001f){
        acc(2) += -9.8f;
        mag(0) += 0.5;
    }
}

void getHilGPSval()
{
    float sigma_vi =  0.1f;
    float sigma_pi =  1.0f;
    
    //GPSの速度情報m/s
    vi(0) =  float(vp.viData[0])/1000.0f + sigma_vi*randn();
    vi(1) =  float(vp.viData[1])/1000.0f + sigma_vi*randn();
    vi(2) =  float(vp.viData[2])/1000.0f + sigma_vi*randn();
    
    //GPSの位置情報m/s
    pi(0) =  float(vp.piData[0])/1.0f + sigma_pi*randn();
    pi(1) =  float(vp.piData[1])/1.0f + sigma_pi*randn();
    pi(2) =  float(vp.piData[2])/1.0f + sigma_pi*randn();
    
}

float randn()
{
    float x = (float)rand()/RAND_MAX;
    float y = (float)rand()/RAND_MAX;
    float z1 = std::sqrt(-2.0 * std::log(x)) * std::cos(2.0 * M_PI_F * y);
    return z1;
}