#ifndef __GLOBAL_HPP__
#define __GLOBAL_HPP__

#include "mbed.h"
#include "SBUS.hpp"
#include "PIDcontroller.h"
#include "LoopTicker.hpp"
#include "FastPWM.h"
#include <cmath>
#include "UsaPack.hpp"
#include "LSM9DS1.h"
#include "LPS.h"
#include "CalibrateMagneto.h"
#include "solaESKF.hpp"
#include "GPSUBX_UART.hpp"
#include "Autopilot.hpp"

// Eigen
#include <Eigen/Dense.h>
//#include <Eigen/Core.h>
//#include <Eigen/LU.h>
//#include <Eigen/Geometry.h>
//using namespace std;
using namespace Eigen;

#define magresThreshold 0.025f
#define ACCEL_SSF 4096.0f
#define GYRO_SSF 131.0f
#define PID_dt 0.015f
#define servoPwmMax  1800.0f
#define servoPwmMin  1200.0f
#define motorPwmMax  2000.0f
#define motorPwmMin  1100.0f

#ifndef M_PI_F
#define M_PI_F 3.141592f
#endif


struct valuePack
{
    int16_t accData[3];
    int16_t gyroData[3];
    int16_t magData[3];
    int16_t viData[3];
    int16_t piData[3];
    //int16_t airspeed;
    //int16_t actData[4];
    int16_t commandIndex;
    int16_t commandVal;
};

struct sendPack
{
    float da;
    float de;
    float dT;
    float euler[3];
    float state[4];
    float variance[3];
    
};
struct logPack
{
    float time; // 1
    float hertz; // 2
    float gpsFix; // 3
    float da; // 4
    float de; // 5
    float dT; // 6
    float rpy[3]; // 7 8 9
    float pihat[3]; // 10 11 12
    float vihat[3]; // 13 14 15
    float pi[3]; // 16 17 18
    float vi[3]; // 19 20 21
    float palt; // 22
    float acc[3]; // 23 24 25
    float gyro[3]; // 26 27 28
    float mag[3]; // 29 30 31
    float rc[16]; // 32 ... 47
    float wind[3]; // 48 49 50
    float pitch_obj; // 51
    float roll_obj; // 52
    float u_pitot; // 53
};

struct telemetryPack
{
    float pi[3];
    float rpy_l[3];
    float rpy_c[3];
    float rpy_r[3];
    float vi[3];
    float palt;
    float gps_fix;
    float mode; //preflight:0, flight:1
    float time;
    float gps_acc;
    float vx_opt;
    float vy_opt;
    float dist_ir;
    float voltage[2];
    float current[2];
    float wind[3];
    float pitch_obj;
    float roll_obj;
    float hinf;
    float u_pitot;
};

// var

// communication

extern UsaPack pc; // log - tail
extern UsaPack sd;
extern UsaPack twelite;

// io
extern DigitalIn userButton;
extern SBUS sbus;
extern I2C i2c;  // sda, scl
extern LSM9DS1 lsm;
extern LPS lps;
extern GPSUBX_UART gps;
extern CalibrateMagneto magCalibrator;

// control
extern Timer _t;
extern FastPWM servoRight;
extern FastPWM servoLeft;
extern FastPWM servoThrust;
extern PID pitchPID; //rad
extern PID pitchratePID;//rad/s
extern PID rollPID;
extern PID rollratePID;//rad/s
extern PID yawratePID;//rad/s
extern PID climbratePID;//rad/s
extern solaESKF eskf; // EKF class
extern Autopilot autopilot;
extern float roll_obj;
extern float pitch_obj;
extern float dT_obj;

extern float rc[16];
extern int loop_count;
extern float att_dt;


// position
extern Matrix3f SensorAlignmentAG;
extern Matrix3f SensorAlignmentMAG; 
extern Vector3f euler;
extern Vector3f acc;
extern Vector3f mag;
extern Vector3f magref;
extern Vector3f gyro;
extern Vector3f vi;
extern Vector3f pi;
extern float palt;
extern float palt0;
extern float dynaccnorm2;
extern int itow_status;
extern bool gpsUpdateFlag;
extern bool gpsLlh0Fixed;
extern bool headingUpdateFlag;
extern bool hinf_flag;

extern float de;
extern float da;
extern float dT;

extern float scaledServoOut[2];
extern float scaledMotorOut[1];
extern float servoOut[2];
extern float motorOut[1];


extern int calibrationFlag;
extern float agoffset[6];


//// UsaPack
extern valuePack vp;
extern sendPack sp;
extern logPack lp;
extern telemetryPack tp;

// HIL
extern bool hilFlag;
extern int16_t hilDataOut;

// function

// main.cpp

// setup.cpp
extern void setup();
extern void calibrate();

// preflight.cpp
extern void preflightCalibration();
extern void preflightCheck();
extern void setEskfCov();

// run.cpp
extern void run();

// imu.cpp
extern void getIMUval();

//gps.cpp
extern void getGPSval();
extern void change_refpos();

// hil.cpp
extern void getHilIMUval();
extern void getHilGPSval();
extern float randn();

//autopilot.cpp
extern void level_flight();
extern void point_guide();
extern void turning();
extern void climb();
extern Vector3f calc_vdot();

// servo.cpp
extern void calcServoOut();

// transferData.cpp
extern void sendData2PC();
extern void sendTelemetry();
extern void writeSDcard();

// global.cpp
extern float mapfloat(float x, float in_min, float in_max, float out_min, float out_max);
extern void setDiag(Matrix3f& mat, float val);
extern void setDiag(MatrixXf& mat, float val);
//extern void setBlockDiag(Matrix3f& mat, float val,int startIndex, int endIndex);
#endif