#include "global.hpp"
 
void level_flight()
{
    Vector3f vdot = calc_vdot();
    Vector3f pihat = eskf.getPihat();
    Vector3f vihat = eskf.getVihat();
    autopilot.update_val(euler, -palt, pihat, vihat, vdot);
    autopilot.level();
    autopilot.keep_alt();
    autopilot.return_val(roll_obj, pitch_obj, dT_obj);
}
 
void point_guide()
{
    Vector3f vdot = calc_vdot();
    Vector3f pihat = eskf.getPihat();
    Vector3f vihat = eskf.getVihat();
    autopilot.update_val(euler, -palt, pihat, vihat, vdot);
    autopilot.guide();
    autopilot.keep_alt();
    autopilot.return_val(roll_obj, pitch_obj, dT_obj);  
}
 
void turning()
{
    Vector3f vdot = calc_vdot();
    Vector3f pihat = eskf.getPihat();
    Vector3f vihat = eskf.getVihat();
    autopilot.update_val(euler, -palt, pihat, vihat, vdot);
    autopilot.turn();
    autopilot.keep_alt();
    autopilot.return_val(roll_obj, pitch_obj, dT_obj);
}

void climb()
{
    Vector3f vdot = calc_vdot();
    Vector3f pihat = eskf.getPihat();
    Vector3f vihat = eskf.getVihat();
    autopilot.update_val(euler, -palt, pihat, vihat, vdot);
    autopilot.level();
    autopilot.climb();
    autopilot.return_val(roll_obj, pitch_obj, dT_obj);
}

Vector3f calc_vdot()
{
    Vector3f m_vdot = eskf.calcDynAcc(acc);
    Vector3f vdot;
    vdot = m_vdot;
    return vdot;
}