#ifndef __USAPACK_HPP__
#define __USAPACK_HPP__

#include "mbed.h"

#define receive_size 256
#define package_types 64
#define send_size 256

class UsaPack
{
private:
    char receive_buffer[receive_size];
    volatile int receive_index;
    volatile int package_index;
    volatile int package_address[package_types];
    volatile int package_size[package_types];
    void* package_object[package_types];
    
    char send_buffer[send_size];
    volatile int send_index;
    volatile int send_end_index;
    
    void Receive();
    void SendByte();
    void Decode();
    
public:
    Serial serial;
    UsaPack(PinName tx, PinName rx, int baud);
    static void CobsEncode(char data[], int length, char send_data[]);
    static void CobsDecode(char receive_data[], int length, char data[]);
    
    template <typename T>
    void Subscribe(int address, T* receive_data)
    {
        package_address[package_index] = address;
        package_size[package_index] = sizeof(T);
        package_object[package_index] = receive_data;
        package_index++;
    }
    
    template <typename T>
    void Send(int address, T* send_data)
    {
        union _package
        {
            struct
            {
                int _address;
                int _checksum;
                T raw_data;
            } address_package;
            char byte_data[sizeof(address_package)];
        };
        char send_cobs_data[sizeof(_package)+2];
        
        _package package;
        package.address_package._address = address;
        package.address_package.raw_data = *send_data;
        
        int checksum = 0;
        for (int i = 8; i < sizeof(_package); i++)
        {
            checksum += package.byte_data[i];
        }
        package.address_package._checksum = checksum;
        
        CobsEncode(package.byte_data, (int)sizeof(_package), send_cobs_data);
        for (int i = 0; i < sizeof(_package)+2; i++)
        {
            send_buffer[(send_end_index + i) % send_size] = send_cobs_data[i];
        }
        send_end_index = (send_end_index + sizeof(_package) + 2) % send_size;
        serial.attach(this, &UsaPack::SendByte, Serial::TxIrq);
    }

    

};


#endif