#include "MedianFilter.hpp"

MedianFilter::MedianFilter(int size)
{
  _size = size;  

  for( float i = 0; i < _size; i++)
    _window.push_back(i);
}

float MedianFilter::Process(float val)
{
  _window.pop_front();
  _window.push_back(val);

  deque<float> _temp(_window);

  sort(_temp.begin(), _temp.end());

  return _temp[_size/2];
}

/*
#include "MedianFilter.hpp"

MedianFilter::MedianFilter(int size)
{
  _size = size;  

  for( float i = 0; i < _size; i++)
  {
    _windowx.push_back(i);
    _windowy.push_back(i);
    _windowz.push_back(i);
    }
}

Vector3 MedianFilter::Process(Vector3 val)
{
  Vector3 out;
  
  _windowx.pop_front();
  _windowx.push_back(val.x);
  deque<float> _tempx(_windowx);
  sort(_tempx.begin(), _tempx.end());
  out.x = _tempx[_size/2];
  
  _windowy.pop_front();
  _windowy.push_back(val.y);
  deque<float> _tempy(_windowy);
  sort(_tempy.begin(), _tempy.end());
  out.y = _tempy[_size/2];
  
  _windowz.pop_front();
  _windowz.push_back(val.z);
  deque<float> _tempz(_windowz);
  sort(_tempz.begin(), _tempz.end());
  out.z = _tempz[_size/2];
  return out;
}


*/