#include "mbed.h"
#include <string.h>
#include "GYSFDMAXB.hpp"


Serial pc(USBTX, USBRX);
GYSFDMAXB gps(PC_12, PD_2);
DigitalOut led(LED1);

void Display()
{
    pc.printf("################################\r\n");
    pc.printf("%d h %d m %d s %d ms\r\n", gps.Hours, gps.Minutes, gps.Seconds, gps.Milliseconds);
    pc.printf("%d / %d / %d\r\n", gps.Year, gps.Month, gps.Day);
    pc.printf("Latitude  : %c %f\r\n", gps.N_S, gps.Latitude);
    pc.printf("Longitude : %c %f\r\n", gps.E_W, gps.Longitude);
    pc.printf("Elevation : %f\r\n", gps.Elevation);
    gps.Calcurate();
    pc.printf("Local N : %f\r\n", gps.Position.x);
    pc.printf("Local E : %f\r\n", gps.Position.y);
    pc.printf("Local D : %f\r\n", gps.Position.z);
    pc.printf("Satellites : %d\r\n", gps.Satellites);
    /*
    pc.printf("start_index : %d\r\n", gps.start_index);
    pc.printf("uart_index : %d\r\n", gps.uart_index);
    
    pc.printf("UniversalZero X : %f\r\n", gps.UniversalZeroPosition.x);
    pc.printf("UniversalZero Y : %f\r\n", gps.UniversalZeroPosition.y);
    pc.printf("UniversalZero Z : %f\r\n", gps.UniversalZeroPosition.z);
    pc.printf("Universal X : %f\r\n", gps.UniversalPosition.x);
    pc.printf("Universal Y : %f\r\n", gps.UniversalPosition.y);
    pc.printf("Universal Z : %f\r\n", gps.UniversalPosition.z);
    */
}


int main()
{
    pc.baud(115200);
    Ticker ticker;
    
    ticker.attach(&Display, 0.3);
    
    led = 1;
    gps.Initialize();
    led = 0;
    
    while (1)
    {
    }
}


// GPS baud rate
/*
Serial gps(PC_12, PD_2);
int main()
{
    gps.baud(9600);
    while (1)
    {
        gps.printf("$PMTK251,57600*2C\r\n");
    }
}



$PMTK251,115200*1F\r\n
$PMTK251,57600*2C\r\n
$PMTK251,9600*17\r\n
*/

/*
Serial pc(USBTX, USBRX);
Serial gps(PC_12, PD_2);

void gps_receive()
{
    while (gps.readable())
    {
        char c;
        c = gps.getc();
        pc.putc(c);
    }
}

int main()
{
    pc.baud(115200);
    gps.baud(57600);
    gps.attach(gps_receive, Serial::RxIrq);
    while (1)
    {
    }
}
*/
/*
$GPGLL,3542.8886,N,13945.7717,E,071533.000,A,A*58
$GPGSA,A,3,21,22,08,194,195,01,,,,,,,2.14,1.90,1.00*07
$GPGSV,4,1,14,195,85,343,35,01,79,276,33,21,69,028,29,194,59,191,33*73
$GPGSV,4,2,14,08,48,067,32,22,47,142,34,14,34,314,16,28,29,316,16*7C
$GPGSV,4,3,14,30,28,267,,07,23,224,,27,16,087,,10,03,033,*7C
$GPGSV,4,4,14,193,,,,38,,,*4C
$GPRMC,071533.000,A,3542.8886,N,13945.7717,E,0.10,53.89,080421,,,A*56
$GPVTG,53.89,T,,M,0.10,N,0.19,K,A*03
$GPZDA,071533.000,08,04,2021,,*58
$GPGGA,071534.000,3542.8886,N,13945.7717,E,1,6,1.90,95.8,M,39.3,M,,*69
$GPGLL,3542.8886,N,13945.7717,E,071534.000,A,A*5F
$GPGSA,A,3,21,22,08,194,195,01,,,,,,,2.14,1.90,1.00*07
$GPGSV,4,1,14,195,85,343,35,01,79,276,33,21,69,028,29,194,59,191,33*73
$GPGSV,4,2,14,08,48,067,32,22,47,142,34,14,34,314,16,28,29,316,16*7C
$GPGSV,4,3,14,30,28,267,,07,23,224,,27,16,087,,10,03,033,*7C
$GPGSV,4,4,14,193,,,,41,,,*42
*/