#ifndef __GPS_HAPS_HPP__
#define __GPS_HAPS_HPP__

#include "mbed.h"
#include "Vector3.hpp"

/*
$GNRMC,090439.00,A,3542.93385,N,13945.73884,E,0.444,,060921,,,A,V*15
$GNVTG,,T,,M,0.444,N,0.822,K,A*31
$GNGGA,090439.00,3542.93385,N,13945.73884,E,1,08,1.32,76.5,M,39.4,M,,*79
$GNGSA,A,3,13,15,18,24,10,23,,,,,,,2.11,1.32,1.65,1*08
$GNGSA,A,3,,,,,,,,,,,,,2.11,1.32,1.65,2*02
$GNGSA,A,3,07,08,,,,,,,,,,,2.11,1.32,1.65,3*0C
$GNGSA,A,3,,,,,,,,,,,,,2.11,1.32,1.65,4*04
$GPGSV,2,1,06,10,33,315,22,13,19,081,10,15,49,080,12,18,24,231,12,1*6B
$GPGSV,2,2,06,23,68,294,22,24,77,009,24,1*6B
$GPGSV,2,1,05,05,15,148,,12,32,157,,14,00,031,,25,13,184,,0*61
$GPGSV,2,2,05,25,13,184,,0*58
$GLGSV,1,1,00,0*79
$GAGSV,2,1,05,02,47,068,25,03,15,100,17,07,50,316,29,08,61,066,23,7*7E
$GAGSV,2,2,05,25,08,035,12,7*4C
$GAGSV,2,1,05,13,12,222,,26,19,275,,27,08,195,,30,50,155,,0*7A
$GAGSV,2,2,05,30,50,155,,0*46
$GBGSV,1,1,00,0*77
$GNGLL,3542.93385,N,13945.73884,E,090439.00,A,A*7E
*/

#define RECEIVE_SIZE 1024
#define SENTENCE_SIZE 256
#define ERROR_F 0.0001f

extern Serial pc;

class GPS_HAPS
{
private:
    Serial serial;
    char receive_buffer[RECEIVE_SIZE];
    char sentence_buffer[SENTENCE_SIZE];
    int receive_start;
    int receive_index;
    int receive_request;
    static const float Radius = 6378136.6f;
    
    void Receive();
    void Parse(char *cmd);
    
public:
    // GPGGA
    volatile int Quality;
    volatile int Satellites;
    volatile float HDOP;
    volatile float Altitude;
    volatile char UnitAltitude;
    volatile float GeoidAltitude;
    volatile char UnitGeoidAltitude;
    
    // GPRMC
    volatile int Hours;
    volatile int Minutes;
    volatile int Seconds;
    volatile int Milliseconds;
    volatile char Status;
    volatile float Latitude;
    volatile char N_S;
    volatile float Longitude;
    volatile char E_W;
    volatile float Speed;
    volatile float Direction;
    volatile int Day;
    volatile int Month;
    volatile int Year;
    volatile float GeomagneticDeclination ;
    volatile char GeomagneticE_W; 
    volatile char Mode;
    volatile int Time;
    
    Vector3 UniversalZeroPosition;
    Vector3 UniversalZeroUnitN;
    Vector3 UniversalZeroUnitE;
    Vector3 UniversalZeroUnitD;
    Vector3 UniversalPosition;
    Vector3 Position;
    Vector3 Velocity;

    GPS_HAPS(PinName tx, PinName rx, int baud);
    void Attach();
    void Loop();
    void Initialize();
    Vector3 ToUniversalUnit();
    Vector3 ToUniversal();
    void CalculateUnit();
    void Calculate();
    Vector3 Calculate(Vector3 position);
};

#endif