#include "mbed.h"
#include "GPSUBX_UART.hpp"
#include "LoopTicker.hpp"

Serial pc(USBTX, USBRX, 115200);
I2C i2c(PB_9, PB_8);
GPSUBX_UART gps(PD_5, PD_6);

LoopTicker gps_ticker;

void Display()
{
    pc.printf("POSLLH: %d, %f, %f, %f\r\n", gps.iTOW_POSLLH, gps.Longitude, gps.Latitude, gps.Height);
    pc.printf("VELNED: %d, %f, %f, %f\r\n", gps.iTOW_VELNED, gps.VelocityNED.x, gps.VelocityNED.y, gps.VelocityNED.z);
    pc.printf("gpsfix: %d, %d\r\n", gps.iTOW_STATUS, gps.gpsFix);
    pc.printf("TIMEUTC: %4d/%2d/%2d %2d:%2d %2d\r\n", gps.Year, gps.Month, gps.Day, gps.Hours, gps.Minutes, gps.Seconds);
    if(gps.gpsFix== 0x02 ||gps.gpsFix== 0x03){
        pc.printf("Fixed\r\n");   
    }
}

int main()
{
    gps.Attach();
    gps_ticker.attach(&Display, 0.2);
    while (1)
    {
        gps.Update();
        gps_ticker.loop();
    }
}