#ifndef __GPSUBX_HPP__
#define __GPSUBX_HPP__

#include "mbed.h"
#include "Vector3.hpp"

#define GPS_ADDRESS 0x23

#define POSECEF_LEN 20
#define POSLLH_LEN 28
#define TIMEUTC_LEN 20
#define VELECEF_LEN 20
#define VELNED_LEN 36


#define UBX_SYNC 0x62 << 8 | 0xb5

extern Serial pc;

struct GPSData
{
    int Year;
    int Month;
    int Day;
    int Hours;
    int Minutes;
    int Seconds;
    int iTOW;
    float Longitude;
    float Latitude;
    float Height;
    float Pressure;
    Vector3 VelocityNED;
    Vector3 PositionNED;
    Vector3 PositionECEF;
};

enum GPSState
{
    WAIT,
    MANUAL,
    AUTO,
    READ,
    STREAM,
    CONFIG    
};

enum LogState
{
    STOP,
    STBY,
    RUNTIME,
    FIN
};

// 0x01 0x01
union POSECEF
{
    char byte_data[POSECEF_LEN+8];
    struct
    {
        unsigned short sync;
        char m_class;
        char m_id;
        unsigned short pay_len;
        unsigned int iTOW;
        int ecefX;
        int ecefY;
        int ecefZ;
        unsigned int pAcc;
        char check_a;
        char check_b;
    } data;
};

// 0x01 0x02
union POSLLH
{
    char byte_data[POSLLH_LEN+8];
    struct
    {
        unsigned short sync;
        char m_class;
        char m_id;
        unsigned short pay_len;
        unsigned int iTOW;
        int lon;
        int lat;
        int height;
        int hMSL;
        unsigned int hAcc;
        unsigned int vAcc;
        char check_a;
        char check_b;
    } data;
};

// 0x01 0x21
union TIMEUTC
{
    char byte_data[TIMEUTC_LEN+8];
    struct
    {
        unsigned short sync;
        char m_class;
        char m_id;
        unsigned short pay_len;
        unsigned int iTOW;
        unsigned int tAcc;
        int nano;
        unsigned short year;
        unsigned char month;
        unsigned char day;
        unsigned char hour;
        unsigned char min;
        unsigned char sec;
        unsigned char valid;
        char check_a;
        char check_b;
    } data;
};

// 0x01 0x11
union VELECEF
{
    char byte_data[VELECEF_LEN+8];
    struct
    {
        unsigned short sync;
        char m_class;
        char m_id;
        unsigned short pay_len;
        unsigned int iTOW;
        int ecefVX;
        int ecefVY;
        int ecefVZ;
        unsigned int sAcc;
        char check_a;
        char check_b;
    } data;  
};

// 0x01 0x12
union VELNED
{
    char byte_data[VELNED_LEN+8];
    struct
    {
        unsigned short sync;
        char m_class;
        char m_id;
        unsigned short pay_len;
        unsigned int iTOW;
        int velN;
        int velE;
        int velD;
        unsigned int speed;
        unsigned int gSpeed;
        signed int heading;
        unsigned int sAcc;
        unsigned int cAcc;
        char check_a;
        char check_b;
    } data;
};

class GPSUBX
{
private:
    I2C i2c;
    char Address;
public:
    int TimeDifference;
    
    GPSUBX(PinName sda, PinName scl, char address, int timedifference, int hz);
    int GetGPSData(GPSData* pdata);
    int GetTimeData(GPSData* pdata);
    
    static void Checksum(char payload[], int n, char* ck_a, char* ck_b);
};

#endif