/***************************************************************************
* Titel        : main.cpp
*
* Description  : Labormodul "HAPOA"
*
* Revision List:
  --------------------------------------------------------------------------
  Date     | Author          | Change
  --------------------------------------------------------------------------
  24.10.22 | J. Altenburg    | Ersterstellung
  --------------------------------------------------------------------------
           |                 |
  ---------------------------------------------------------------------------
  
  Editor List:
  --------------------------------------------------------------------------
  Date     | Author          | Change
  --------------------------------------------------------------------------
  30.11.22 |Tobias Zinke     | Labor03
  --------------------------------------------------------------------------
  30.11.22 |Alexander Pitthan| Labor03
  ---------------------------------------------------------------------------
****************************************************************************/
#include "mbed.h"
#include "cdef.h"

AnalogIn    pinPoti (A0);

/* Vereinbarungen zu den Tasteneingängen */
DigitalIn   pinS1(A1);
DigitalIn   pinS2(A2);
DigitalIn   pinS3(A3);

//BusOut      bLedShield(D10, D11, D12, D13);

/* Anschlüsse der Schieberegister */
DigitalOut  pinSdo(PA_9);
DigitalOut  pinSck(PA_8);
DigitalOut  pinLoad(PB_5);
DigitalOut  pinBeep(PB_3);

/* ISR */
Ticker      stTimer;

/***************************************************************************
*   Defines und Makros                                                       *
***************************************************************************/
#define nTastShort  20      /* Taste 50 Millisekunden gedrückt */    
#define nTastLong   240     /* Taste 0.6 Sekunden gedrückt */ 
#define nCircleTime 2500    /* Laufzeit der Main in us */

#define nSegA           0x01
#define nSegB           0x02
#define nSegC           0x04
#define nSegD           0x08
#define nSegE           0x10
#define nSegF           0x20
#define nSegG           0x40
#define nSegH           0x80

#define nZiffer0    ~(nSegA | nSegB | nSegC | nSegD | nSegE | nSegF)
#define nZiffer1    ~(nSegB | nSegC)
#define nZiffer2    ~(nSegA | nSegB | nSegD | nSegE | nSegG)
#define nZiffer3    ~(nSegA | nSegB | nSegC | nSegD | nSegG)
#define nZiffer4    ~(nSegB | nSegC | nSegF | nSegG)
#define nZiffer5    ~(nSegA | nSegC | nSegD | nSegF | nSegG)
#define nZiffer6    ~(nSegA | nSegC | nSegD | nSegE | nSegF | nSegG)
#define nZiffer7    ~(nSegA | nSegB | nSegC)
#define nZiffer8    ~(nSegA | nSegB | nSegC | nSegD | nSegE | nSegF | nSegG)
#define nZiffer9    ~(nSegA | nSegB | nSegC | nSegD | nSegF | nSegG)
#define nZifferA    ~(nSegA | nSegB | nSegC | nSegE | nSegF | nSegG)
#define nZifferB    ~(nSegC | nSegD | nSegE | nSegF | nSegG)
#define nZifferC    ~(nSegA | nSegD | nSegE | nSegF)
#define nZifferD    ~(nSegB | nSegC | nSegD | nSegE | nSegG)
#define nZifferE    ~(nSegA | nSegD | nSegE | nSegF | nSegG)
#define nZifferF    ~(nSegA | nSegE | nSegF | nSegG)
#define nZifferOff   (nSegA | nSegB | nSegC | nSegD | nSegE | nSegF | nSegG | nSegH)

byte bIdx; /*
* Description : Index auf Ausgabe
*/

byte bDigit; /*
* Description : aktives Digit
*/

byte bBargraph; /*
* Description : Bargraph durchschalten
*/

byte bS1Timer; /*
* Description : Timer für Taste S1
*/

byte bS2Timer; /*
* Description : Timer für Taste S2
*/

byte bS3Timer; /*
* Description : Timer für Taste S3
*/

byte bSCounter; /*
* Description : Zähler UART-Auslese für Tasterersatz
*/

byte bDisplayState; /*
* Description : 
*/
const byte enSchwellenwert=0x00;
const byte enPotiAnzeige = 0x01;
const byte enVergleich = 0x02;


byte bState; /*
* Description : 
*/

byte bHotKey; /*
* Description : Auswahl der Taste
*/

byte bDisplayDot; /*
* Description : 
*/

byte bMainState; /*
* Description : Hauptzustand
*/

byte bBeepTime; /*
* Description : Tondauer 
*/

byte bEinstellungsModus;/*
* Description : Einstellungszustand 
*/

byte bSchwellenwertVergleich;/*
* Description : Einstellungszustand 
*/

byte bTimeLong;/*
* Description : Ob Taste bereits lange gedrückt war 
*/

byte bSizeData;/*
* Description : Größe der Daten
*/
byte *pUartData; /*
* Description : pointer to data
*/

byte bComp;


word wSerial; /*
* Description : serielles Ausgaberegister
*/

word wClockTime; /*
*Description : Timer für verstrichene Zeit
*/

word wClockShow; /*
*Description : Timer für verstrichene Zeit
*/

word wDelayGame; /*
* Description : Verzögerungstimer
*/

word wPotiWert; /*
* Description : Wert des Potis
*/

word wVorgabeWert; /*
* Description : eingestellter Vorgabewert
*/

int nDiffWert; /*
* Description : Differenz zwischen Vorgabe und Eingang
*/

word wSizeData; /*
* Description : Größe der empfangenen Daten
*/

word wTimerDot; /*
* Description : Zähler für Dots
*/

int zaehler;

/* Bitmuster */
const byte abZiffer[] = {nZiffer0, nZiffer1, nZiffer2, nZiffer3, nZiffer4, nZiffer5, nZiffer6, nZiffer7, nZiffer8, nZiffer9, nZifferA, nZifferB, nZifferC, nZifferD, nZifferE, nZifferF, nZifferOff};
//const byte abBargraph[] = {~Bit0, ~(Bit0|Bit1), ~(Bit0|Bit1|Bit2), ~(Bit0|Bit1|Bit2|Bit3), 0x0f};
byte abTxBuffer[60];
byte abTxBufferOld[60];



void vShiftLoad(word wLoad){
    word wMask = Bit15;
    pinLoad = 0;
    while(wMask){
        if(wMask & wLoad) pinSdo = 1;
        else              pinSdo = 0;
        pinSck = 1;
        wMask >>= 1;
        pinSck = 0;
        }    
    pinLoad = 1;
    }


byte abDisplayMemory[] = {16,16,16,16}; /* alle Segmente aus */

void vDisplayVolt( word w )
{
    int16 v;
    abDisplayMemory[0] = 16; /* Aus */
    v = (byte)(w / 1000);
    abDisplayMemory[1] = v; /* Hunderter */
    w = w - (v * 1000);
    v = (byte)(w / 100);
    abDisplayMemory[2] = v; /* Zehner */
    w = w - (v * 100);
    v = (byte)(w / 10);
    abDisplayMemory[3] = v; /* Einer */
}

void vDisplayDiff( word w )
{
    int16 v;
    abDisplayMemory[0] = 12; /* "C" */
    v = (byte)(w / 1000);
    abDisplayMemory[1] = v; /* Hunderter */
    w = w - (v * 1000);
    v = (byte)(w / 100);
    abDisplayMemory[2] = v; /* Zehner */
    w = w - (v * 100);
    v = (byte)(w / 10);
    abDisplayMemory[3] = v; /* Einer */
}

void vSetForStart( void )
{
    abDisplayMemory[0] = 16; /* 7-Segment-Display ausschalten */
    abDisplayMemory[1] = 16;
    abDisplayMemory[2] = 16;
    abDisplayMemory[3] = 16;
    wTimerDot = 0;
    bDigit = 0;
    bMainState = enSchwellenwert;
    bDisplayState = enSchwellenwert;
    pinBeep = 1;
    wVorgabeWert = 0;
}

/* Tastenabfrage */
void vTasteS1( void ){
    if(pinS1 == 0){                             /* User-Taste gedrückt */      
        if(bS1Timer < nTastLong+1){             /* Abfrage max. bis Taste lange gedrückt */
            if(bS1Timer == nTastShort){         /* Taste "kurz gedrückt" erkannt */
                //...
                }
            if(bS1Timer == nTastLong){          /* Taste "lange gedrückt" erkannt */ 
                if(bDisplayState == enSchwellenwert){
                    bDisplayState = enVergleich;
                    bMainState = enVergleich;
                    }
                else{
                    bDisplayState = enSchwellenwert;
                    bMainState = enSchwellenwert;
                    }
                }
            bS1Timer++;
            }
        }
    else{                                       /* Taste nicht gedrückt */ 
        if(((bS1Timer >= nTastShort) && (bS1Timer <= nTastLong))){             /* Taste wurde bereits erkannt */
            if(bDisplayState == enSchwellenwert){
                    bDisplayState = enPotiAnzeige; 
                    bMainState = enPotiAnzeige;
                    }
                else{ 
                    bDisplayState = enSchwellenwert;
                    bMainState= enSchwellenwert;
                    }
            }
        bS1Timer = 0;
        }
    } 

void vTasteS2( void ){
    if((pinS2 == 0) && bMainState == enSchwellenwert){                             /* User-Taste gedrückt */    
        if(bS2Timer < nTastLong+1){             /* Abfrage max. bis Taste lange gedrückt */
            if(bS2Timer == nTastShort){         /* Taste "kurz gedrückt" erkannt */
                //...
                }
            if(bS2Timer == nTastLong){          /* Taste "lange gedrückt" erkannt */ 
                bTimeLong = 1;
                if(wVorgabeWert >=3200) wVorgabeWert = 3300;
                else wVorgabeWert = wVorgabeWert + 100;
                bS2Timer = bS2Timer - 40;
                }
            bS2Timer++;
            }
        }
    else{                                       /* Taste nicht gedrückt */ 
        if(((bS2Timer >= nTastShort) && (bS2Timer <= nTastLong))){             /* Taste wurde bereits erkannt */
            if(bTimeLong==0){
                if(wVorgabeWert >=3290) wVorgabeWert = 3300;
                else wVorgabeWert = wVorgabeWert + 10;
            }
            }
        bS2Timer = 0;
        bTimeLong = 0;
        }
    } 

void vTasteS3( void ){
    if(pinS3 == 0 && bMainState == enSchwellenwert){                             /* User-Taste gedrückt */
        if(bS3Timer < nTastLong+1){             /* Abfrage max. bis Taste lange gedrückt */
            if(bS3Timer == nTastShort){         /* Taste "kurz gedrückt" erkannt */
                //...
                }
            if(bS3Timer == nTastLong){          /* Taste "lange gedrückt" erkannt */ 
                bTimeLong = 1;
                if(wVorgabeWert <=100) wVorgabeWert = 0;
                else wVorgabeWert = wVorgabeWert - 100;
                bS3Timer = bS3Timer - 40;
                }
            bS3Timer++;
            }
        }
    else{                                       /* Taste nicht gedrückt */ 
        if((bS3Timer >= nTastShort) && (bS3Timer <= nTastLong)){             /* Taste wurde bereits erkannt */
            if(bTimeLong==0){
                if(wVorgabeWert <=10) wVorgabeWert = 0;
                else wVorgabeWert = wVorgabeWert - 10;
            }
            }
        bS3Timer = 0;
        bTimeLong = 0;
        }
    } 



void vCheckTasten( void ){
    vTasteS1();
    vTasteS2();
    vTasteS3();
    }
void vSegmentDigit( void ) //wichtig!!
{
    bDigit++;
    wSerial = abZiffer[abDisplayMemory[bDigit&0x03]];
    switch(bDisplayState) {
        case enSchwellenwert:
            wTimerDot++; /* Zähler für Punktwechsel */
            vDisplayVolt(wVorgabeWert);
            if(wTimerDot == 400) {
                wDelayGame=200;
                wTimerDot = 0;
            }
            if(wDelayGame!=0){
                if((bDigit&0x03) == 0x01) {
                    wSerial = wSerial & ~nSegH; /* Punktanzeigen */
                }  
                wDelayGame--;
            }
            break;
        case enPotiAnzeige:
                vDisplayVolt(wPotiWert);
            if((bDigit&0x03) == 0x01) { /* Dezimalpunkt setzen */
                wSerial = wSerial & ~nSegH;
            }
            break;
        case enVergleich:
            vDisplayDiff(nDiffWert);
            if((bDigit&0x03) == 0x01) { /* Dezimalpunkt setzen */
                wSerial = wSerial & ~nSegH;
                }
            break;
    }
    vShiftLoad(((wSerial << 8) & 0xfff0)| (1 << (bDigit&0x03)));
}










Serial stComX(D1,D0); // UART-Kommunikation (Txd(D1)/Rxd(D0)) mit dem PC 
 
/*
byte SYS_vStartComX( word wSize, byte *pData ){ // Start einer Übertragung 
byte i;
if(wSizeData) i = False;
else{
wSizeData = wSize; // Anzahl der Sendedaten 
pUartData = pData; // Zeiger auf diese Daten 
stComX.putc(*pUartData); // erstes Zeichen senden 
pUartData++;
wSizeData--;
USART2->CR1 |= USART_CR1_TXEIE; // TXE-Interrupt freigeben 
i = True;
}
return i;
}


// Senderoutine zum COM-Port am PC 
void vIsrTxComX( void ){ // Senderoutine 
if(stComX.writeable()){ // Sende-ISR 
if(bSizeData){ // sind Daten vorhanden ? 
stComX.putc(*pUartData); // daten senden 
pUartData++;
bSizeData--;
}
else{
USART2->CR1 &= ~USART_CR1_TXEIE; // Interrupt sperren 
}
}
}


// Empfangsroutine vom COM-Port des PC 
void vIsrRxComX( void ){ // Empfangsroutine 
if(stComX.readable()){ // Empfangs-ISR 
for(int i=60; i>0; i--){
    abTxBufferOld[i]=abTxBuffer[i];
}
for(int i=60; i>0; i--){
    abTxBuffer[i]=abTxBuffer[i-1];
}
abTxBuffer[0] = stComX.getc();
SYS_vStartComX(1, &abTxBuffer[0]);
}
}
*/



void vComA(void){
    if(abTxBuffer[0]=='a'){
        if(bMainState==enSchwellenwert) {
            bDisplayState = enPotiAnzeige;
            bMainState = enPotiAnzeige;
        }
        else if(bMainState==enPotiAnzeige) {
            bDisplayState = enVergleich;
            bMainState = enVergleich;
        }
        else {
            bDisplayState = enSchwellenwert;
            bMainState = enSchwellenwert;
        }
    }
}

void vComPlus(void){
    if(abTxBuffer[0]=='+'){
        if(wVorgabeWert >=3290) wVorgabeWert = 3300;
        else wVorgabeWert = wVorgabeWert + 10;
    }
}

void vComMinus(void){
    if(abTxBuffer[0]=='-'){
        if(wVorgabeWert <=10) wVorgabeWert = 0;
        else wVorgabeWert = wVorgabeWert - 10;;
    }
}

void vCheckCom(void){
    vComA();
    vComPlus();
    vComMinus();
}




/***************************************************************************
*   main()
***************************************************************************/
int main() {
    /* Variablen initialisieren */    
    vSetForStart();


    //Seriel.begin(9600);
    
   
    while(1) {    
        wPotiWert = pinPoti*3300;  
        vCheckTasten();
        nDiffWert = wVorgabeWert - wPotiWert;
        
        if(stComX.readable()) {
            abTxBuffer[0]=stComX.getc();
        }
        
        //stComX.attach(&vIsrRxComX, Serial::RxIrq); /* ISR zum Datemempfang vom PC */
        //stComX.attach(&vIsrTxComX, Serial::TxIrq); /* Sende-ISR */
        
        vCheckCom();
    
    
        switch(bMainState) {
            case enSchwellenwert:
                pinBeep = 1;
                break;
            case enPotiAnzeige:
                pinBeep = 1;
                break;
            case enVergleich:
                if(nDiffWert<0) pinBeep=0;
                else pinBeep=1;
                break;
        }
        vSegmentDigit();
        wait_us(nCircleTime);
    }
}