/***************************************************************************
* Titel        : main.cpp
*
* Description  : Labormodul "HAPOA"
*
* Revision List:
  --------------------------------------------------------------------------
  Date     | Author          | Change
  --------------------------------------------------------------------------
  24.10.22 | J. Altenburg    | Ersterstellung
  --------------------------------------------------------------------------
           |                 |
  ---------------------------------------------------------------------------
  
  Editor List:
  --------------------------------------------------------------------------
  Date     | Author          | Change
  --------------------------------------------------------------------------
  20.11.22 |Tobias Zinke     | Labor02
  --------------------------------------------------------------------------
  20.11.22 |Alexander Pitthan| Labor02
  ---------------------------------------------------------------------------
****************************************************************************/
#include "mbed.h"
#include "cdef.h"

/* Vereinbarungen zu den Tasteneingängen */
DigitalIn   pinS1(A1);
DigitalIn   pinS2(A2);
DigitalIn   pinS3(A3);

BusOut      bLedShield(D10, D11, D12, D13);

/* Anschlüsse der Schieberegister */
DigitalOut  pinSdo(PA_9);
DigitalOut  pinSck(PA_8);
DigitalOut  pinLoad(PB_5);
DigitalOut  pinBeep(PB_3);

/* ISR */
Ticker      stTimer;

/***************************************************************************
*   Defines und Makros                                                       *
***************************************************************************/
#define nTastShort    4     /* Taste 50 Millisekunden gedrückt */    
#define nTastLong   150     /* Taste 1.5 Sekunden gedrückt */ 

#define nSegA           0x01
#define nSegB           0x02
#define nSegC           0x04
#define nSegD           0x08
#define nSegE           0x10
#define nSegF           0x20
#define nSegG           0x40
#define nSegH           0x80

#define nZiffer0    ~(nSegA | nSegB | nSegC | nSegD | nSegE | nSegF)
#define nZiffer1    ~(nSegB | nSegC)
#define nZiffer2    ~(nSegA | nSegB | nSegD | nSegE | nSegG)
#define nZiffer3    ~(nSegA | nSegB | nSegC | nSegD | nSegG)
#define nZiffer4    ~(nSegB | nSegC | nSegF | nSegG)
#define nZiffer5    ~(nSegA | nSegC | nSegD | nSegF | nSegG)
#define nZiffer6    ~(nSegA | nSegC | nSegD | nSegE | nSegF | nSegG)
#define nZiffer7    ~(nSegA | nSegB | nSegC)
#define nZiffer8    ~(nSegA | nSegB | nSegC | nSegD | nSegE | nSegF | nSegG)
#define nZiffer9    ~(nSegA | nSegB | nSegC | nSegD | nSegF | nSegG)
#define nZifferA    ~(nSegA | nSegB | nSegC | nSegE | nSegF | nSegG)
#define nZifferB    ~(nSegC | nSegD | nSegE | nSegF | nSegG)
#define nZifferC    ~(nSegA | nSegD | nSegE | nSegF)
#define nZifferD    ~(nSegB | nSegC | nSegD | nSegE | nSegG)
#define nZifferE    ~(nSegA | nSegD | nSegE | nSegF | nSegG)
#define nZifferF    ~(nSegA | nSegE | nSegF | nSegG)
#define nZifferOff   (nSegA | nSegB | nSegC | nSegD | nSegE | nSegF | nSegG | nSegH)

byte bIdx; /*
* Description : Index auf Ausgabe
*/

byte bDigit; /*
* Description : aktives Digit
*/

byte bBargraph; /*
* Description : Bargraph durchschalten
*/

byte bS1Timer; /*
* Description : Timer für Taste S1
*/

byte bS2Timer; /*
* Description : Timer für Taste S2
*/

byte bS3Timer; /*
* Description : Timer für Taste S3
*/

byte bDisplayState; /*
* Description : 
*/
const byte enWaitForStart=0x00;
const byte enRunClock = 0x01;
const byte enShowResult = 0x02;
const byte enShowError = 0x03;
const byte enWaitForRun = 0x04;


byte bState; /*
* Description : 
*/

byte bTimerDot; /*
* Description : Zähler für Dots
*/

byte bHotKey; /*
* Description : Auswahl der Taste
*/

byte bDisplayDot; /*
* Description : 
*/

byte bMainState; /*
* Description : Hauptzustand
*/

byte bBeepTime; /*
* Description : Tondauer 
*/


word wSerial; /*
* Description : serielles Ausgaberegister
*/

word wClockTime; /*
*Description : Timer für verstrichene Zeit
*/

word wClockShow; /*
*Description : Timer für verstrichene Zeit
*/

word wDelayGame; /*
* Description : Verzögerungstimer
*/

/* Bitmuster */
const byte abZiffer[] = {nZiffer0, nZiffer1, nZiffer2, nZiffer3, nZiffer4, nZiffer5, nZiffer6, nZiffer7, nZiffer8, nZiffer9, nZifferA, nZifferB, nZifferC, nZifferD, nZifferE, nZifferF, nZifferOff};
const byte abBargraph[] = {~Bit0, ~(Bit0|Bit1), ~(Bit0|Bit1|Bit2), ~(Bit0|Bit1|Bit2|Bit3), 0x0f};


void vShiftLoad(word wLoad){
    word wMask = Bit15;
    pinLoad = 0;
    while(wMask){
        if(wMask & wLoad) pinSdo = 1;
        else              pinSdo = 0;
        pinSck = 1;
        wMask >>= 1;
        pinSck = 0;
        }    
    pinLoad = 1;
    }


byte abDisplayMemory[] = {16,16,16,16}; /* alle Segmente aus */

void vDisplayClock( word w )
{
    int16 v;
    abDisplayMemory[0] = 16; /* Aus */
    v = (byte)(w / 100);
    abDisplayMemory[1] = v; /* Hunderter */
    w = w - (v * 100);
    v = (byte)(w / 10);
    abDisplayMemory[2] = v; /* Zehner */
    w = w - (v * 10);
    abDisplayMemory[3] = (byte)w; /* Einer */
}

void vSetWaitForStart( void )
{
    abDisplayMemory[0] = 16; /* 7-Segment-Display ausschalten */
    abDisplayMemory[1] = 16;
    abDisplayMemory[2] = 16;
    abDisplayMemory[3] = 16;
    bDisplayState = enWaitForStart;
    bTimerDot = 0;
    bDigit = 0;
}

void vSetRunClock( void )
{
    wClockTime = 0;
    bDigit = 0;
    abDisplayMemory[0] = 16; /* 7-Segment-Display ausschalten */
    abDisplayMemory[1] = 0;
    abDisplayMemory[2] = 0;
    abDisplayMemory[3] = 0;
    bDisplayState = enRunClock;
}

byte bCheckTasten( byte bState )
{
    if((pinS1 == 0) || (pinS2 == 0) || (pinS3 == 0)) { /* Tastendruck erkannt */
        wClockShow = 1200;
        if((pinS1 == 0) && (bHotKey == 0)) {
            wDelayGame = 0;
            bState = enShowResult;
            bDisplayState = enShowResult;
        } else if((pinS2 == 0) && (bHotKey == 1)) {
            wDelayGame = 0;
            bState = enShowResult;
            bDisplayState = enShowResult;
        } else if((pinS3 == 0) && (bHotKey == 2)) {
            wDelayGame = 0;
            bState = enShowResult;
            bDisplayState = enShowResult;
        } else {
            wDelayGame = 200;
            abDisplayMemory[1] = 15;
            abDisplayMemory[2] = 15;
            abDisplayMemory[3] = 15;
            bState = enShowError;
            bDisplayState = enShowResult;
            pinBeep = 0;
        }
    }
    return bState;
}

void vSegmentDigit( void )
{
    bDigit++;
    wSerial = abZiffer[abDisplayMemory[bDigit&0x03]];
    switch(bDisplayState) {
        case enWaitForStart:
            bTimerDot++; /* Zähler für Punktwechsel */
            if(bTimerDot == 50) {
                bTimerDot = 0;
                bDisplayDot = (bDisplayDot + 1) & 0x03;
            }
            if(bDisplayDot == (bDigit&0x03)) {
                wSerial = wSerial & ~nSegH; /* Punktanzeigen */
            }
            break;
        case enRunClock:
            if((bDigit&0x03) == 0x03){ /* Ablauf von 10 ms */
                wClockTime++;
                if(wClockTime > 999) {
                    wClockTime = 0;
                }
                vDisplayClock(wClockTime);
            }
            if((bDigit&0x03) == 0x01) { /* Dezimalpunkt setzen */
                wSerial = wSerial & ~nSegH;
            }
            break;
        case enShowResult:
            if((bDigit&0x03) == 0x01) { /* Dezimalpunkt setzen */
                wSerial = wSerial & ~nSegH;
                }
            break;
    }
    vShiftLoad(((wSerial << 8) & 0xfff0)| (1 << (bDigit&0x03)));
}

void vBargraph(byte bTaste){
    switch(bTaste){
        case 0 :
            bLedShield =0b1110;
            break;
        case 1 :
            bLedShield =0b1101;
            break;
        case 2 :
            bLedShield =0b1011;
            break;
    }
}

/***************************************************************************
*   main()
***************************************************************************/
int main() {
    /* Variablen initialisieren */    
    byte bRandomTaste = 0;
    word wRandomClock = 0;
    bMainState = enWaitForStart;
    bDisplayState = enWaitForStart;
    pinBeep = 1;
    vSetWaitForStart();
    
    while(1) {        
        bRandomTaste++;
        if(bRandomTaste > 2) bRandomTaste = 0; /* zufällige LED/Taste bestimmen */
        wRandomClock++;
        if(wRandomClock > 800) wRandomClock = 0; /* Zufallszeit erzeugen */
        switch(bMainState) {
            case enWaitForStart:
                wDelayGame++;
                bLedShield =0b1111;
                if(wDelayGame > 1200) { /* 3 Sekundenminimum */
                    wDelayGame = wRandomClock;
                    bMainState = enWaitForRun;
                }
                break;
            case enRunClock:
                bBeepTime--;
                if(bBeepTime == 0)pinBeep = 1;
                bMainState = bCheckTasten(enRunClock);
                break;
            case enWaitForRun:
                wDelayGame--;
                if(wDelayGame == 0){
                    bMainState = enRunClock;
                    bDisplayState = enRunClock;
                    bBeepTime = 20;
                    bHotKey = bRandomTaste;
                    vBargraph(bRandomTaste);
                    vSetRunClock();
                    pinBeep = 0;
                    }
                break;
            case enShowResult:
                wClockShow--;
                if(wClockShow==0){
                    bMainState = enWaitForStart;
                    bDisplayState = enWaitForStart;
                    vSetWaitForStart();
                    }
                break;
            case enShowError:
                wDelayGame--;
                if(wDelayGame == 0)pinBeep = 1;
                wClockShow--;
                if(wClockShow==0){
                    bMainState = enWaitForStart;
                    bDisplayState = enWaitForStart;
                    wDelayGame = 0;
                    vSetWaitForStart();
                    }
                break;
        }
        vSegmentDigit();
        wait_us(2500);
    }
}