/***************************************************************************
* Titel        : main.c
*
* Description  : Labormodul "DIBI"
*
* Revision List:
  --------------------------------------------------------------------------
  Date     | Author          | Change
  --------------------------------------------------------------------------
  24.10.22 | J. Altenburg    | Ersterstellung
  --------------------------------------------------------------------------
           |                 |
  ----------------------------------------------------------------------------
****************************************************************************/
#include "mbed.h"
#include "cdef.h"

/* Vereinbarungen zu den Tasteneingängen */
DigitalIn   pinS1(A1);
DigitalIn   pinS2(A2);
DigitalIn   pinS3(A3);

BusOut      bLedShield(D10, D11, D12, D13);

/* Anschlüsse der Schieberegister */
DigitalOut  pinSdo(PA_9);
DigitalOut  pinSck(PA_8);
DigitalOut  pinLoad(PB_5);

/* ISR */
Ticker      stTimer;

/***************************************************************************
*   Defines und Makros                                                       *
***************************************************************************/
#define nTastShort    4     /* Taste 50 Millisekunden gedrückt */    
#define nTastLong   150     /* Taste 1.5 Sekunden gedrückt */ 

#define nSegA           0x01
#define nSegB           0x02
#define nSegC           0x04
#define nSegD           0x08
#define nSegE           0x10
#define nSegF           0x20
#define nSegG           0x40
#define nSegH           0x80

#define nZiffer0    ~(nSegA | nSegB | nSegC | nSegD | nSegE | nSegF)
#define nZiffer1    ~(nSegB | nSegC)
#define nZiffer2    ~(nSegA | nSegB | nSegD | nSegE | nSegG)
#define nZiffer3    ~(nSegA | nSegB | nSegC | nSegD | nSegG)
#define nZiffer4    ~(nSegB | nSegC | nSegF | nSegG)
#define nZiffer5    ~(nSegA | nSegC | nSegD | nSegF | nSegG)
#define nZiffer6    ~(nSegA | nSegC | nSegD | nSegE | nSegF | nSegG)
#define nZiffer7    ~(nSegA | nSegB | nSegC)
#define nZiffer8    ~(nSegA | nSegB | nSegC | nSegD | nSegE | nSegF | nSegG)
#define nZiffer9    ~(nSegA | nSegB | nSegC | nSegD | nSegF | nSegG)
#define nZifferA    ~(nSegA | nSegB | nSegC | nSegE | nSegF | nSegG)
#define nZifferB    ~(nSegC | nSegD | nSegE | nSegF | nSegG)
#define nZifferC    ~(nSegA | nSegD | nSegE | nSegF)
#define nZifferD    ~(nSegB | nSegC | nSegD | nSegE | nSegG)
#define nZifferE    ~(nSegA | nSegD | nSegE | nSegF | nSegG)
#define nZifferF    ~(nSegA | nSegE | nSegF | nSegG)
#define nZifferOff   (nSegA | nSegB | nSegC | nSegD | nSegE | nSegF | nSegG | nSegH)

byte bIdx; /*
* Description : Index auf Ausgabe
*/

byte bDigit; /*
* Description : aktives Digit
*/

byte bBargraph; /*
* Description : Bargraph durchschalten
*/

byte bS1Timer; /*
* Description : Timer für Taste S1
*/

byte bS2Timer; /*
* Description : Timer für Taste S2
*/

byte bS3Timer; /*
* Description : Timer für Taste S3
*/

word wSerial; /*
* Description : serielles Ausgaberegister
*/

/* Bitmuster */
const byte abZiffer[] = {nZiffer0, nZiffer1, nZiffer2, nZiffer3, nZiffer4, nZiffer5, nZiffer6, nZiffer7, nZiffer8, nZiffer9, nZifferA, nZifferB, nZifferC, nZifferD, nZifferE, nZifferF, nZifferOff};
const byte abBargraph[] = {~Bit0, ~(Bit0|Bit1), ~(Bit0|Bit1|Bit2), ~(Bit0|Bit1|Bit2|Bit3), 0x0f};


/* Tastenabfrage */
void vTasteS1( void ){
    if(pinS1 == 0){                             /* User-Taste gedrückt */
        if(bS1Timer < nTastLong+1){             /* Abfrage max. bis Taste lange gedrückt */
            if(bS1Timer == nTastShort){         /* Taste "kurz gedrückt" erkannt */
                //...
                }
            if(bS1Timer == nTastLong){          /* Taste "lange gedrückt" erkannt */ 
                if(bIdx > 0) bIdx--;
                else bIdx = 16;
                }
            bS1Timer++;
            }
        }
    else{                                       /* Taste nicht gedrückt */ 
        if((bS1Timer >= nTastShort) && (bS1Timer <= nTastLong)){             /* Taste wurde bereits erkannt */
            if(bIdx < 16) bIdx++;
            else bIdx = 0;
            }
        bS1Timer = 0;
        }
    } 

void vTasteS2( void ){
    if(pinS2 == 0){                             /* User-Taste gedrückt */
        if(bS2Timer < nTastLong+1){             /* Abfrage max. bis Taste lange gedrückt */
            if(bS2Timer == nTastShort){         /* Taste "kurz gedrückt" erkannt */
                //...
                }
            if(bS2Timer == nTastLong){          /* Taste "lange gedrückt" erkannt */ 
                if(bDigit > 0b00000001) bDigit = bDigit>>1;
                else bDigit = 0b00001000;
                }
            bS2Timer++;
            }
        }
    else{                                       /* Taste nicht gedrückt */ 
        if((bS2Timer >= nTastShort) && (bS2Timer <= nTastLong)){             /* Taste wurde bereits erkannt */
            if(bDigit < 0b00001000) bDigit = bDigit<<1;
            else bDigit = 0b00000001;
            }
        bS2Timer = 0;
        }
    } 

void vTasteS3( void ){
    if(pinS3 == 0){                             /* User-Taste gedrückt */
        if(bS3Timer < nTastLong+1){             /* Abfrage max. bis Taste lange gedrückt */
            if(bS3Timer == nTastShort){         /* Taste "kurz gedrückt" erkannt */
                //...
                }
            if(bS3Timer == nTastLong){          /* Taste "lange gedrückt" erkannt */ 
                bBargraph--;
                }
            bS3Timer++;
            }
        }
    else{                                       /* Taste nicht gedrückt */ 
        if((bS3Timer >= nTastShort) && (bS3Timer <= nTastLong)){             /* Taste wurde bereits erkannt */
            bBargraph++;
            }
        bS3Timer = 0;
        }
    } 



void vCheckTasten( void ){
    vTasteS1();
    vTasteS2();
    vTasteS3();
    }

/* Ausschieben der 16 Bits für die Anzeige */
void vShiftLoad(word wLoad){
    word wMask = Bit15;
    pinLoad = 0;
    while(wMask){
        if(wMask & wLoad) pinSdo = 1;
        else              pinSdo = 0;
        pinSck = 1;
        wMask >>= 1;
        pinSck = 0;
        }    
    pinLoad = 1;
    }

/***************************************************************************
*   main()
***************************************************************************/
int main() {
    /* Variablen initialisieren */    
    bIdx = 0;
    bDigit = 0b00000001;
    bLedShield = 0x00;
    while(1){
        vCheckTasten();
        wSerial = abZiffer[bIdx]<<8 | bDigit ;            /* 7-Segmentziffer bestimmen */
        vShiftLoad(wSerial);          /* Segmente verschieben und Digit festlegen */
        bLedShield = abBargraph[bBargraph & 0x03];          /* Bargraph bestimmen */
        wait_us(10000);
        }
    }
