//////////////////////////////////////////////////////////////////////////////////////
//                                                                                  //
//      File        : LCD_I2C.cpp                                                   //
//      Version     : 1.0                                                           //
//      Date        : 26 june 2015                                                  //
//      Author      : Dany Brugman                                                  //
//      Comment     : Class to write data to a 2x16 LCD by I2C                      //
//                    using a MCP23017 port expander.                               //
//                                                                                  //
//      Changelog   :                                                               //
//      Date:           Name:       Comment:                                        //
//      25/03/2015      DNB         First version                                   //
//      26/06/2015      DNB         Rebuild to class LCD_I2C                        //
//                                                                                  //
//////////////////////////////////////////////////////////////////////////////////////
#include "menu.h"
#include "LCD_I2C.h"

//////////////////////////////////////////////////////////////////////////////////////
// constructor                                                                      //
//////////////////////////////////////////////////////////////////////////////////////
LCD_I2C::LCD_I2C(PinName data, PinName clk, char deviceID) : 
         i2c(data, clk), 
         deviceAdress(deviceID),
         mcp23017(i2c, 0x40)
{
    vLCD_init_I2C();
};

LCD_I2C::~LCD_I2C()
{
};


extern Menu mLCDMenu;
//////////////////////////////////////////////////////////////////////////////////////
// delay function for LCD                                                           //
//////////////////////////////////////////////////////////////////////////////////////
void LCD_I2C::vLCD_delay_I2C (unsigned int t_delay)
{
    unsigned int i;
    
    for (i=0; i < t_delay; i++);
}

//////////////////////////////////////////////////////////////////////////////////////
// write commando to LCD                                                            //
//////////////////////////////////////////////////////////////////////////////////////
void LCD_I2C::vLCD_cmd_I2C   (unsigned char commando)
{
__disable_irq();    // Disable Interrupts

    // write commando to LCD
    mcp23017.write(PORT_A, commando);
    
    // LCD_RS = 0
    buffer_GPIOB = buffer_GPIOB & 0xFD;   // RS = 0
    // write to LCD
    mcp23017.write(PORT_B, buffer_GPIOB);
    
    // LCD_EN = 1
    buffer_GPIOB = buffer_GPIOB | 0x01;   // EN = 1
    // write to LCD
    mcp23017.write(PORT_B, buffer_GPIOB);
    
    // LCD_EN = 0
    buffer_GPIOB = buffer_GPIOB & 0xFE;   // EN = 0
    // write to LCD
    mcp23017.write(PORT_B, buffer_GPIOB);
    
__enable_irq();     // Enable Interrupts
}

//////////////////////////////////////////////////////////////////////////////////////
// write single char to LCD                                                         //
//////////////////////////////////////////////////////////////////////////////////////
void LCD_I2C::vLCD_data_I2C  (unsigned char data)
{
__disable_irq();    // Disable Interrupts
 
    // write data to LCD
    mcp23017.write(PORT_A, data);
    
    // LCD_RS = 1
    buffer_GPIOB = buffer_GPIOB | 0x02;   // RS = 1
    // write to LCD
    mcp23017.write(PORT_B, buffer_GPIOB);
    
    // LCD_EN = 1
    buffer_GPIOB = buffer_GPIOB | 0x01;   // EN = 1
    // write to LCD
    mcp23017.write(PORT_B, buffer_GPIOB);
    
    // LCD_EN = 0
    buffer_GPIOB = buffer_GPIOB & 0xFE;   // EN = 0
    // write to LCD
    mcp23017.write(PORT_B, buffer_GPIOB);
    
__enable_irq();     // Enable Interrupts
}

//////////////////////////////////////////////////////////////////////////////////////
// Initialize LCD                                                                   //
//////////////////////////////////////////////////////////////////////////////////////
void LCD_I2C::vLCD_init_I2C  (void)
{
    // init port expander
    //Port A is databus - Output
    mcp23017.direction(PORT_A, PORT_DIR_OUT);
    //Port B is controlbus - Output
    mcp23017.direction(PORT_B, PORT_DIR_OUT);
    
    vLCD_cmd_I2C (0x00);
    // vLCD_delay_I2C (65535)
    vLCD_delay_I2C (100);
    
    vLCD_cmd_I2C (0x38);
    // vLCD_delay_I2C (65535)
    vLCD_delay_I2C (100);
    
    vLCD_cmd_I2C (0x38);
    //vLCD_delay_I2C (65535)
    vLCD_delay_I2C (100);
    
    vLCD_cmd_I2C (0x38);
    //vLCD_delay_I2C (65535)
    vLCD_delay_I2C (100);
    
    // Display ON / OFF
    vLCD_cmd_I2C (0x08);
    
    //vLCD_delay_I2C (65535)
    vLCD_delay_I2C (100);
    
    // Clear Display
    vLCD_cmd_I2C (0x01);
    
    //vLCD_delay_I2C (65535)
    vLCD_delay_I2C (100);
    
    // Entry Mode Set
    vLCD_cmd_I2C (0x06);
    
    //vLCD_delay_I2C (65535)
    vLCD_delay_I2C (100);
    
    // Display ON / OFF
    vLCD_cmd_I2C (0x0C);
    
    //vLCD_delay_I2C (65535)
    vLCD_delay_I2C (100);
}

//////////////////////////////////////////////////////////////////////////////////////
// Write string to LCD                                                              //
//////////////////////////////////////////////////////////////////////////////////////
void LCD_I2C::vLCD_print_I2C (unsigned char *string, unsigned char line)
{
    unsigned int i;
    
    // select target line to write to
    if (line == 1)
    {
        vLCD_cmd_I2C (0x80);
    }
    else if (line == 2)
    {
        vLCD_cmd_I2C (0xC0);
    }
    else
    {
        return;    // End of function: Error in the past value of line
    }
    
    // write data to selected line
    for (i=0; i<16; i++)
    {
        if (string [i] != 0x00) 
        {
            vLCD_data_I2C (string [i]);
        }
        else
            vLCD_data_I2C (' ');
    }
}

//////////////////////////////////////////////////////////////////////////////////////
// Write string to LCD                                                              //
//////////////////////////////////////////////////////////////////////////////////////
void LCD_I2C::vLCD_printPos_I2C (unsigned char *string, unsigned char line, unsigned char character)
{
    unsigned int i;
    
    // select target line and position to write to
    if (line == 1)
    {
        vLCD_cmd_I2C (0x80+(character-1));
    }
    
    else if (line == 2)
    {
        vLCD_cmd_I2C (0xC0+(character-1));
    }
    
    else
    {
        return;    // End of function: Error in the past value of line
    }
    
    // write data to selected line and position
    for (i=0; i<16; i++)
    {
        if (string [i] != 0x00)
        {
            vLCD_data_I2C (string [i]);
        }
        else
            vLCD_data_I2C (' ');
    }
}

//////////////////////////////////////////////////////////////////////////////////////
// Writing integer to LCD                                                           //
//////////////////////////////////////////////////////////////////////////////////////
void LCD_I2C::vLCD_printInt_I2C (int value, unsigned char line, unsigned char character)
{
        static char buffer[32];
        // convert int to char
        sprintf(buffer, "%.2d", value);
        // write converted int to LCD
    vLCD_printPos_I2C((unsigned char*)buffer, line, character);
}

//////////////////////////////////////////////////////////////////////////////////////
// clear LCD [unsed]                                                                //
//////////////////////////////////////////////////////////////////////////////////////
void LCD_I2C::vLCD_clear_I2C (void)
{
    // Clear Display
    vLCD_cmd_I2C (0x01);
    //vLCD_delay_I2C (65535)
    vLCD_delay_I2C (100);
    // Display ON / OFF
    vLCD_cmd_I2C (0x0C);
    //vLCD_delay_I2C (65535)
    vLCD_delay_I2C (100);
}

//////////////////////////////////////////////////////////////////////////////////////
// update LCD                                                                       //
//////////////////////////////////////////////////////////////////////////////////////
void LCD_I2C::vLCD_update (void)
{
   vLCD_print_I2C((unsigned char*)mLCDMenu.getLine1(), 1);
   vLCD_print_I2C((unsigned char*)mLCDMenu.getLine2(), 2);
   //vLCD_printPos_I2C((unsigned char*)mLCDMenu.getLine1(), 1, 1);
   //vLCD_printPos_I2C((unsigned char*)mLCDMenu.getLine2(), 2, 1);
}