/******************************************************************************
 * Module         : UART
 * Copyright      : 2008 - H. Arends
 * Description    : STK525 Driver
 ******************************************************************************
   Change History:
 
   Version 0.1 - March 2008
    > Initial revision

******************************************************************************/

/******************************************************************************

******************************************************************************/

#ifndef _UART_H_
#define _UART_H_

/******************************************************************************
  Defines
******************************************************************************/
#define BAUDRATE            9600

#define CR                  ('\r')
#define LF                  ('\n')
#define BACKSPACE           ('\b')
#define SPACE               (' ')
#define ESC                 0x1B


/******************************************************************************
  Function prototypes
******************************************************************************/
void          UART_vInitIO  (void);
void          UART_vPutStr  (char *p);
void          UART_vGetStr  (unsigned short l, char *p);
int           UART_iPutCh   (int c);
unsigned char UART_ucGetCh  (void);
void          UART_vPutInt  (int c);

void          UART_vPutStr_P(uint8_t *p);

#endif // _UART_H_

/******************************************************************************
  EOF
******************************************************************************/
