/******************************************************************************
 * Module         : UART
 * Copyright      : 2008 - H. Arends
 * Description    : STK525 Driver
 ******************************************************************************
    Change History:
    
    Version 0.2 - November 2011
    > Port to mbed
    
    Version 0.1 - March 2008
    > Initial revision

******************************************************************************/

/******************************************************************************
  Include files
******************************************************************************/
#include "mbed.h"

#include "uart.h"


/******************************************************************************
  Global variables
******************************************************************************/
Serial pc(USBTX, USBRX);  // Seri&#65533; verbinding met PC terminal


/******************************************************************************
  UART_ Function implementation
******************************************************************************/
void UART_vInitIO (void)
{
  // Initialise UART
  pc.baud(BAUDRATE);        // Baudrate
  pc.format(8, Serial::None, 1);    // UART Frame format
}

/******************************************************************************

******************************************************************************/
void UART_vPutStr (char *p)
{
  while(*p)
  {
    if(*p == LF) {UART_iPutCh(CR);}
    UART_iPutCh(*p++);
  }
}

/******************************************************************************

******************************************************************************/
void UART_vGetStr (unsigned short l, char *p)
{
  signed short    t = 0;

  while ((p[t] = UART_ucGetCh ()) != CR)
  {
    t++;
  }
  p[t] = '\0';
}

/******************************************************************************

******************************************************************************/
int UART_iPutCh (int c)
{
  return pc.putc(c);
}

/******************************************************************************

******************************************************************************/
unsigned char UART_ucGetCh (void)
{
  // wait for data received by the UART
 // while ((UCSR1A & _BV(RXC1)) == 0) {;}
  //return UDR1;
  //return OS_iPutCh(UDR);
  return pc.getc();
}

/******************************************************************************

******************************************************************************/
void UART_vPutStr_P (char *p)
{
  /*while(pgm_read_byte(p))
  {
    if(pgm_read_byte(p) == LF) {UART_iPutCh(CR);}
    UART_iPutCh(pgm_read_byte(p++));
  }*/
  pc.printf(p);
}

/******************************************************************************

******************************************************************************/
void UART_vPutInt  (int c)
{
  pc.printf("%i", c);
}
/******************************************************************************
  EOF
******************************************************************************/
