#ifndef SYSTEMVAR_H_INCLUDED
#define SYSTEMVAR_H_INCLUDED

#include "mbed.h"
#include "string.h"
#include "Quaternion.h"

//Solar on Foils display values
enum VALUE_t
{
//////////////////////////////////////////////////////////////////////////////////////
// system measured values                                                           //
////////////////////////////////////////////////////////////////////////////////////// 
    _ROLL = 0,          // roll
    _PITCH,             // pitch
    _PHEIGHT,           // portside height
    _SHEIGHT,           // starboard height
    _PCURRENT,          // portside current
    _SCURRENT,          // starboard current 
    _SPEED,             // speed
//////////////////////////////////////////////////////////////////////////////////////
// system variables                                                                 //
//////////////////////////////////////////////////////////////////////////////////////     
    _MAXROLL,           // variable max roll
    _MINPITCH,          // variable min pitch
    _MAXPITCH,          // variable max pitch
    _TAKEOFFSPEED,      // variable take off speed
    _HEIGHTFOILBORNE,   // variable flight height foilborne
    _HEIGHTFOILASSIST,  // variable flight height foil assist
    _AOAFOILASSIST      // variable AOA foil assist
};

class SystemVar
{
    private:
        // variable
                
        char cValue[4];
        char cMessage;
        
        VALUE_t value;
        
        uint32_t uiCounter;
        uint32_t uiRoll[2];
        uint32_t uiPitch[2];
        uint32_t uiPHeight;
        uint32_t uiSHeight;
        uint32_t uiPCurrent;
        uint32_t uiSCurrent;
        uint32_t uiSpeed;
        uint32_t uiVarMaxRoll;
        uint32_t uiVarMinPitch;
        uint32_t uiVarMaxPitch;
        uint32_t uiVarTakeOffSpeed;
        uint32_t uiVarHeightFoilBorne;
        uint32_t uiVarHeightFoilAssist;
        uint32_t uiVarAOAFoilAssist;
                
        bool bError;
        
    public:
        // Constructor
        SystemVar();
        // Destructor
        ~SystemVar();
        
        // Gets
        char* getValue(void); 
        int iGetRollPolarity(void);
        int iGetPitchPolarity(void);
        uint32_t uiGetRoll(void);
        uint32_t uiGetPitch(void);
        int32_t iGetHeightFoilBorne(void);
        uint32_t uiGetVarMaxRoll(void);
        uint32_t uiGetVarMinPitch(void);
        uint32_t uiGetVarMaxPitch(void);
        uint32_t uiGetVarTakeOffSpeed(void);
        uint32_t uiGetVarHeightFoilBorne(void);
        uint32_t uiGetVarHeightFoilAssist(void);
        uint32_t uiGetVarAOAFoilAssist(void);


        // Sets
        void vSetRoll(Quaternion);
        void vSetPitch(Quaternion);
        void vSetPHeight(uint32_t);
        void vSetSHeight(uint32_t);
        void vSetPCurrent(uint32_t);
        void vSetSCurrent(uint32_t);
        void vSetSpeed(uint32_t);
        // Set variables
        void vVarMaxRoll(uint32_t);
        void vVarMinPitch(uint32_t);
        void vVarMaxPitch(uint32_t);
        void vVarTakeOffSpeed(uint32_t);
        void vVarHeightFoilBorne(uint32_t);
        void vVarHeightFoilAssist(uint32_t);
        void vVarAOAFoilAssist(uint32_t);

        // Other functions
        void init(void);
        void itoa( uint32_t , char *);
        void cShowValue(VALUE_t);
        void vIncrease(VALUE_t);
        void vDecrease(VALUE_t);
        
};
#endif
