//////////////////////////////////////////////////////////////////////////////////////
//                                                                                  //
//      File        : systemVar.cpp                                                 //
//      Version     : 0.1                                                           //
//      Date        : 23 june 2015                                                  //
//      Author      : Dany Brugman                                                  //
//      Comment     : Class systemVar to manage and control system variables        //
//                                                                                  //
//      Changelog   :                                                               //
//      Date:           Name:       Comment:                                        //
//      23/06/2015      DNB         First version                                   //
//                                                                                  //
//////////////////////////////////////////////////////////////////////////////////////
#include "menu.h"
#include "systemVar.h"

//////////////////////////////////////////////////////////////////////////////////////
// Defines                                                                          //
//////////////////////////////////////////////////////////////////////////////////////
#define EXT_UI_HEIGHT           1020 
           
//////////////////////////////////////////////////////////////////////////////////////
// Variable limits                                                                  //
//////////////////////////////////////////////////////////////////////////////////////
#define MAXMAXROLL              30 
#define MAXMINPITCH             15
#define MAXMAXPITCH             30
#define MAXTAKEOFFSPEED         15
#define MAXFOILBORNEHEIGHT      30
#define MAXFOILASSISTHEIGHT     30
#define MAXAOA                  8
#define MINMAXROLL              5                 
#define MINMINPITCH             5
#define MINMAXPITCH             5
#define MINTAKEOFFSPEED         1
#define MINFOILBORNEHEIGHT      1
#define MINFOILASSISTHEIGHT     1
#define MINAOA                  1

//////////////////////////////////////////////////////////////////////////////////////
// Contructor                                                                       //
//////////////////////////////////////////////////////////////////////////////////////
SystemVar::SystemVar() : 
           uiCounter(0),
           uiVarHeightFoilBorne(30),
           bError(0)           
        {
            init();
        };

SystemVar::~SystemVar()
{
};

extern Serial debug;
extern CAN CANbus;

//////////////////////////////////////////////////////////////////////////////////////
// init                                                                             //
////////////////////////////////////////////////////////////////////////////////////// 
void SystemVar::init(void)
{
    //init here
}

//////////////////////////////////////////////////////////////////////////////////////
// set's                                                                            //
////////////////////////////////////////////////////////////////////////////////////// 
void SystemVar::vSetRoll(Quaternion q1)
{
    float fRoll;
    uint32_t uiValue;
    fRoll = atan2(2*(q1.v.x*q1.v.y + q1.w*q1.v.y), q1.w*q1.w + q1.v.x*q1.v.x - q1.v.y*q1.v.y - q1.v.y*q1.v.y);
    fRoll *= 180/3.14;
    if(fRoll >= 0) uiRoll[0] = 1;
    else uiRoll[0] = 0;
    uiValue = (uint32_t) abs(fRoll);
    uiRoll[1] = uiValue;
}

void SystemVar::vSetPitch(Quaternion q1)
{
    float fPitch;
    uint32_t uiValue;
    Vector3 euler = q1.getEulerAngles();
    fPitch = euler.y;
    fPitch *= 180/3.14;
    if(fPitch >= 0) uiPitch[0] = 1;
    else uiPitch[0] = 0;
    uiValue = (uint32_t) abs(fPitch);
    uiPitch[1] = uiValue;        
}
        
void SystemVar::vVarHeightFoilBorne(uint32_t uiValue)
{
    cMessage = uiValue;
    CANbus.write(CANMessage(EXT_UI_HEIGHT, &cMessage, 1));
    uiVarHeightFoilBorne = uiValue;
    debug.printf("set height %i\t", uiVarHeightFoilBorne);
}

void SystemVar::vSetPHeight(uint32_t uiValue)
{
    uiPHeight = uiValue;
}

void SystemVar::vSetSHeight(uint32_t uiValue)
{
    uiSHeight = uiValue;
}

void SystemVar::vSetPCurrent(uint32_t uiValue)
{
     uiPCurrent = uiValue;   
}
        
void SystemVar::vSetSCurrent(uint32_t uiValue)
{
    uiSCurrent = uiValue; 
}

void SystemVar::vSetSpeed(uint32_t uiValue)
{
    uiSpeed = uiValue;
}

//////////////////////////////////////////////////////////////////////////////////////
// get's                                                                            //
////////////////////////////////////////////////////////////////////////////////////// 
char* SystemVar::getValue(void) 
{
     static char* pValue;
     pValue = cValue;
     return pValue;
}

int SystemVar::iGetRollPolarity(void)
{
    return uiRoll[0];
}

int SystemVar::iGetPitchPolarity(void)
{
    return uiPitch[0];
}

uint32_t SystemVar::uiGetRoll(void)
{
    return uiRoll[1];
}

uint32_t SystemVar::uiGetPitch(void)
{
    return uiPitch[1];
}

int32_t SystemVar::iGetHeightFoilBorne(void)
{
    return uiVarHeightFoilBorne;
}

uint32_t SystemVar::uiGetVarMaxRoll(void)
{
    return uiVarMaxRoll;    
}
        
uint32_t SystemVar::uiGetVarMinPitch(void)
{
    return uiVarMinPitch;   
}
       
uint32_t SystemVar::uiGetVarMaxPitch(void)
{
    return uiVarMaxPitch;
}

uint32_t SystemVar::uiGetVarTakeOffSpeed(void)
{
    return uiVarTakeOffSpeed;
}

uint32_t SystemVar::uiGetVarHeightFoilBorne(void)
{
    return uiVarHeightFoilBorne;
}

uint32_t SystemVar::uiGetVarHeightFoilAssist(void)
{
    return uiVarHeightFoilAssist;
}

uint32_t SystemVar::uiGetVarAOAFoilAssist(void)
{
    return uiVarAOAFoilAssist;
}

        
        
        
        
//////////////////////////////////////////////////////////////////////////////////////
// convert value to char *                                                          //
//////////////////////////////////////////////////////////////////////////////////////
void SystemVar::itoa( uint32_t value, char *str)
{   
   int i,j;
   char temp[4];
   for(i=0; value > 0; i++){    
       str[i] = value%10+'0';
       value=value/10;
    }
    for(j=0;i>=0;j++,i--){
        temp[j]=str[i-1];
    }
    for(i=0;i<j;i++){
        str[i]=temp[i];
    }
    if(strcmp(str,"")== 0) str[0] = '0';
       
}

//////////////////////////////////////////////////////////////////////////////////////
// show value                                                                       //
////////////////////////////////////////////////////////////////////////////////////// 
void SystemVar::cShowValue(VALUE_t v)
{
    value = v;
    switch(value)
    {
        case _ROLL:             itoa(uiRoll[1], cValue); break;
                                
        case _PITCH:            itoa(uiPitch[1], cValue); break;
        
        //case _HEIGHTFOILBORNE:  itoa(uiVarHeightFoilBorne, cValue); break;
        
        case _PHEIGHT:          itoa(uiPHeight, cValue); break;
        
        case _MAXROLL:          itoa(uiVarMaxRoll, cValue); break;
        
        case _MINPITCH:         itoa(uiVarMinPitch, cValue); break;
        
        case _MAXPITCH:         itoa(uiVarMaxPitch, cValue); break;
        
        case _TAKEOFFSPEED:     itoa(uiVarTakeOffSpeed, cValue); break;
        
        case _HEIGHTFOILBORNE:  itoa(uiVarHeightFoilBorne, cValue); break;
        
        case _HEIGHTFOILASSIST: itoa(uiVarHeightFoilAssist, cValue); break;
        
        case _AOAFOILASSIST:    itoa(uiVarAOAFoilAssist, cValue); break;        
    } // end switch
    
}

//////////////////////////////////////////////////////////////////////////////////////
// in-/decrease value                                                               //
////////////////////////////////////////////////////////////////////////////////////// 
void SystemVar::vIncrease(VALUE_t v)
{
    value = v;
    switch(value)
    {
        case _MAXROLL:          if(uiVarMaxRoll >= MAXMAXROLL) uiVarMaxRoll++; break; 
        
        case _MINPITCH:         if(uiVarMinPitch >= MAXMINPITCH) uiVarMinPitch++; break;
        
        case _MAXPITCH:         if(uiVarMaxPitch >= MAXMAXPITCH) uiVarMaxPitch++; break;
        
        case _TAKEOFFSPEED:     if(uiVarTakeOffSpeed >= MAXTAKEOFFSPEED) uiVarTakeOffSpeed++; break;
        
        case _HEIGHTFOILBORNE:  if(uiVarHeightFoilBorne >= MAXFOILBORNEHEIGHT) uiVarHeightFoilBorne++; break;
        
        case _HEIGHTFOILASSIST: if(uiVarHeightFoilAssist >= MAXFOILASSISTHEIGHT) uiVarHeightFoilAssist++; break;
        
        case _AOAFOILASSIST:    if(uiVarAOAFoilAssist >= MAXAOA) uiVarAOAFoilAssist++; break;          
    }//end switch  
}
      
void SystemVar::vDecrease(VALUE_t v)
{
    value = v;
    switch(value)
    {
        case _MAXROLL:          if(uiVarMaxRoll <= MINMAXROLL) uiVarMaxRoll--; break; 
        
        case _MINPITCH:         if(uiVarMinPitch <= MINMINPITCH) uiVarMinPitch--; break;
        
        case _MAXPITCH:         if(uiVarMaxPitch <= MINMAXPITCH) uiVarMaxPitch--; break;
        
        case _TAKEOFFSPEED:     if(uiVarTakeOffSpeed <= MINTAKEOFFSPEED) uiVarTakeOffSpeed--; break;
        
        case _HEIGHTFOILBORNE:  if(uiVarHeightFoilBorne <= MINFOILBORNEHEIGHT) uiVarHeightFoilBorne--; break;
        
        case _HEIGHTFOILASSIST: if(uiVarHeightFoilAssist <= MINFOILASSISTHEIGHT) uiVarHeightFoilAssist--; break;
        
        case _AOAFOILASSIST:    if(uiVarAOAFoilAssist <= MINAOA) uiVarAOAFoilAssist--; break;
    }//end switch     
}



//////////////////////////////////////////////////////////////////////////////////////
// EOF                                                                              //
//////////////////////////////////////////////////////////////////////////////////////
