#ifndef MENU_H_INCLUDED
#define MENU_H_INCLUDED

#include "mbed.h"
#include "systemVar.h"

//Solar on Foils display screens
enum SCREEN_t
{
//////////////////////////////////////////////////////////////////////////////////////
// base screens                                                                     //
//////////////////////////////////////////////////////////////////////////////////////    
    _INIT = 0,              // Initialize screen
    _STANDBY,               // Standby screen
    _ACTIVE,                // Active screen
//////////////////////////////////////////////////////////////////////////////////////
// menulayer 0 settings                                                             //
//////////////////////////////////////////////////////////////////////////////////////    
    _SETTINGS0,             // Settings level 0 screen
    _SETTINGS1,             // Settings level 1 screen
    _SETTINGS2,             // Settings level 2 screen
//////////////////////////////////////////////////////////////////////////////////////
// menulayer 1 settings                                                             //
//////////////////////////////////////////////////////////////////////////////////////    
    _SYSTEMVAR0,            // System variable groep select level 0 screen
    _SYSTEMVAR1,            // Safety margins level 1 screen
    _SYSTEMVAR2,            // Safety margins level 2 screen
    _SYSTEMVAR3,            // Safety margins level 3 screen
    _SYSTEMVAR4,            // Safety margins level 4 screen
//////////////////////////////////////////////////////////////////////////////////////
// menulayer 2 settings                                                             //
//////////////////////////////////////////////////////////////////////////////////////    
    _SYSTEMVARSELECT0,      // Select system variable to change level 0 screen
    _SYSTEMVARSELECT1,      // Select system variable to change level 1 screen
    _SYSTEMVARSELECT2,      // Select system variable to change level 2 screen
    _SYSTEMVARSELECT3,      // Select system variable to change level 3 screen
    _SYSTEMVARSELECT4,      // Select system variable to change level 4 screen
    _SYSTEMVARSELECT5,      // Select system variable to change level 5 screen
//////////////////////////////////////////////////////////////////////////////////////
// menulayer 3 settings                                                             //
//////////////////////////////////////////////////////////////////////////////////////    
    _MUTATESYSTEMVAR0,      // mutate system variable level 0 screen
    _MUTATESYSTEMVAR1,      // mutate system variable level 1 screen
    _MUTATESYSTEMVAR2,      // mutate system variable level 2 screen
    _MUTATESYSTEMVAR3,      // mutate system variable level 3 screen
    _MUTATESYSTEMVAR4,      // mutate system variable level 4 screen
    _MUTATESYSTEMVAR5,      // mutate system variable level 5 screen
    _MUTATESYSTEMVAR6,      // mutate system variable level 6 screen
    _MUTATESYSTEMVAR7,      // mutate system variable level 7 screen
    
    _FOILBORNE,             // foilborne screen
    _FOILASSIST,            // foil assist screen
    _HOMESCREEN,            // home screen
//////////////////////////////////////////////////////////////////////////////////////
// CAN messages                                                                     //
//////////////////////////////////////////////////////////////////////////////////////    
    _CANINIT,
    _CANFAIL,
    _CANERROR,
    _CANOK,
    _CANNORESPONSE,
    _CANID101OK,
    _CANID102OK,
    _CANID201OK,
    _CANID202OK,
    _CANID205OK,
    _CANID1001OK,
    _CANID101FAIL,
    _CANID102FAIL,
    _CANID201FAIL,
    _CANID202FAIL,
    _CANID205FAIL,
    _CANID1001FAIL,
//////////////////////////////////////////////////////////////////////////////////////
// IMU messages                                                                     //
//////////////////////////////////////////////////////////////////////////////////////         
    _IMUREADY,
    _IMUFAIL,
    _ROLLTEST,              // roll test displays roll value
    _PITCHTEST,             // pitch test displays pitch value
    _HEIGHTTEST,
    _SHOWHEIGHTFB,          // display height value
    _PULSE_IS,
    _CAUTION,               // Caution screen
//////////////////////////////////////////////////////////////////////////////////////
// multiple used screens                                                            //
//////////////////////////////////////////////////////////////////////////////////////     
    _BACK,                  // Back screen
    _HOME,                  // Home screen
    _PROGRESS               // development screen
};
//////////////////////////////////////////////////////////////////////////////////////
// MENU_t conform menu structure Functioneel_ontwerp_03_20150609                    //
//////////////////////////////////////////////////////////////////////////////////////
enum MENU_t
{
    _MENU0_0 = 0,           // Initialize screen
    _MENU0_1,               // Standby screen
    
    _MENU0_2,               // Settings screen
    _MENU1_20,              // Variable settings screen 0
    _MENU1_21,              // Variable settings screen 1
    _MENU1_22,              // Variable settings screen 2
    _MENU1_23,              // Variable settings screen 3
    _MENU1_24,              // Variable settings screen 4
    
    _MENU2_20,              // Variable settings select screen 0
    _MENU2_21,              // Variable settings select screen 1
    _MENU2_22,              // Variable settings select screen 2
    _MENU2_23,              // Variable settings select screen 3
    _MENU2_24,              // Variable settings select screen 4
    _MENU2_25,              // Variable settings select screen 5
    
    _MENU3_20,              // Variable settings mutatie screen 0
    _MENU3_21,              // Variable settings mutatie screen 1
    _MENU3_22,              // Variable settings mutatie screen 2
    _MENU3_23,              // Variable settings mutatie screen 3
    _MENU3_24,              // Variable settings mutatie screen 4
    _MENU3_25,              // Variable settings mutatie screen 5
    _MENU3_26,              // Variable settings mutatie screen 6
    
    _MENU0_3,               // Viewsettings screen
    _MENU1_31,              // View roll angle screen
    _MENU1_32,              // View pitch angle screen
    _MENU1_33,              // View height settings screen
    _MENU1_34,              // View port height measured
    
    _MENU0_4,               // Diagnosis screen
    _MENU1_4,               // Diagnosis menu screen
    
    _BACKBACK,              // Back back
    _BACKHOME               // Back home
};

class Menu
{
    private:
        // variable
                
        char cTextLine1[18];
        char cTextLine2[18];
        char cStatus;
        
        SCREEN_t screen;
        MENU_t menu, nextMenu, prevMenu, confMenu, backToFrom;
        VALUE_t valueToChange;
        
        uint32_t uiCounter;
                
        bool bMenu;             // true item is menu, false item is value
        bool bConfirm;          // confirm menu or value item 
        bool bReadHeight;       // allow writing CAN height module on CANbus
        bool bError;
        
    public:
        // Constructor
        Menu();
        // Destructor
        ~Menu();
        
        // Init
        void init(void);
        // Gets
        char* getLine1(void);
        char* getLine2(void); 
        SCREEN_t getScreen(void); 
        bool bGetReadHeight(void);   

        // Sets

        // Other functions
        void vShowScreen(SCREEN_t);
        void vSelectMenu(MENU_t);
        void vRotaryUp(void);
        void vRotaryDown(void);
        void vRotaryConfirm(void);
        void vFillString1(void);        // Fill string1 upto 16 characters
        void vFillString2(void);        // Fill string2 upto 16 characters
        void vCheckReadHeight(void);
        
};
#endif
