#include "menu.h"
#include "string.h"

#define DEVICE_ID   201

// Contructor
Menu::Menu() : 
           uiCounter(0),
           bMenu(1),
           bReadHeight(0),
           bError(0)           
        {
            init();
        };

Menu::~Menu()
{
};

extern Menu mLCDMenu; 
extern SystemVar svSoF;
extern Serial debug;
extern CAN CANbus;
//////////////////////////////////////////////////////////////////////////////////////
// init                                                                             //
////////////////////////////////////////////////////////////////////////////////////// 
void Menu::init(void)
{
    memset (cTextLine1,' ',16);
    memset (cTextLine2,' ',16);
}
//////////////////////////////////////////////////////////////////////////////////////
// set's                                                                            //
////////////////////////////////////////////////////////////////////////////////////// 

//////////////////////////////////////////////////////////////////////////////////////
// get's                                                                            //
////////////////////////////////////////////////////////////////////////////////////// 
char* Menu::getLine1(void)
{
     static char* pLine1;
     pLine1 = cTextLine1;
     return pLine1;
}

char* Menu::getLine2(void)
{
     static char* pLine2;
     pLine2 = cTextLine2;
     return pLine2;
}

SCREEN_t Menu::getScreen(void)
{
   return screen;    
} 

bool Menu::bGetReadHeight(void)
{
    return bReadHeight;
}
//////////////////////////////////////////////////////////////////////////////////////
// other                                                                            //
////////////////////////////////////////////////////////////////////////////////////// 
void Menu::vRotaryUp(void)
{
    if((nextMenu != _BACKBACK)||(nextMenu != _BACKHOME)) backToFrom = nextMenu;     // remember previous menu exept back and home
    if(bMenu) vSelectMenu(nextMenu);
    else if(!bMenu)
    {
        svSoF.vIncrease(valueToChange);   // to construct
        vSelectMenu(nextMenu);
    }
    vCheckReadHeight();
    //debug.printf("backToFrom %i\r\n", backToFrom);  
}

void Menu::vRotaryDown(void)
{
    if((nextMenu != _BACKBACK)||(nextMenu != _BACKHOME)) backToFrom = nextMenu;     // remember previous menu exept back and home
    if(bMenu) vSelectMenu(prevMenu);
    else if(!bMenu)
    {
        svSoF.vDecrease(valueToChange);   // to construct
        vSelectMenu(nextMenu);
    }
    vCheckReadHeight();
    //debug.printf("backToFrom %i\r\n", backToFrom);
}

void Menu::vRotaryConfirm(void)
{
    if(bMenu) vSelectMenu(confMenu);
    else if (!bMenu) 
    {
        bMenu = true;
        vSelectMenu(confMenu);
    }
    //debug.printf("rotary confirm\r\n"); 
}

void Menu::vFillString1(void)
{
    int i;
    int length = strlen(cTextLine1);
    for (i=length; i < 16; i++) strcat(cTextLine1," ");
}

void Menu::vFillString2(void)
{
    int i;
    int length = strlen(cTextLine2);
    for (i=length; i < 16; i++) strcat(cTextLine2," ");
}

void Menu::vCheckReadHeight(void)       // used for project demo only
{
     if(bReadHeight)
     { 
        cStatus = 0xff;
        CANbus.write(CANMessage(DEVICE_ID, &cStatus, 1)); // send clearance true to port height
     }
     else 
     {
        cStatus = 0x00;
        CANbus.write(CANMessage(DEVICE_ID, &cStatus, 1)); // send clearance false to port height
     }
}
 
//////////////////////////////////////////////////////////////////////////////////////
// show screens                                                                     //
////////////////////////////////////////////////////////////////////////////////////// 
void Menu::vShowScreen(SCREEN_t s)
{
    screen = s;
    uiCounter = rand()% 100 + 1;
    switch(screen)
    {
//////////////////////////////////////////////////////////////////////////////////////
// base screens                                                                     //
//////////////////////////////////////////////////////////////////////////////////////        
        case _INIT:             strcpy(cTextLine1," Solar on Foils ");
                                strcpy(cTextLine2,"   Initialize   "); break;
        
        case _STANDBY:          strcpy(cTextLine1," Solar on Foils ");
                                strcpy(cTextLine2," system STANDBY "); break;
        
        case _ACTIVE:           strcpy(cTextLine1," Solar on Foils ");
                                strcpy(cTextLine2," system ACTIVE  "); break;                        
//////////////////////////////////////////////////////////////////////////////////////
// menulayer 0 settings                                                             //
//////////////////////////////////////////////////////////////////////////////////////                                
        case _SETTINGS0:        strcpy(cTextLine1,">Settings       ");
                                strcpy(cTextLine2," View settings  "); break;
                                
        case _SETTINGS1:        strcpy(cTextLine1,">View settings  ");
                                strcpy(cTextLine2," Diagnosis      "); break;
                                
        case _SETTINGS2:        strcpy(cTextLine1," View settings  ");
                                strcpy(cTextLine2,">Diagnosis      "); break;

//////////////////////////////////////////////////////////////////////////////////////
// menulayer 1 settings                                                             //
//////////////////////////////////////////////////////////////////////////////////////                                
        case _SYSTEMVAR0:       strcpy(cTextLine1,">Safety margins ");
                                strcpy(cTextLine2," Take-off speed "); break; 
        
        case _SYSTEMVAR1:       strcpy(cTextLine1,">Take-off speed ");
                                strcpy(cTextLine2," Height F-borne "); break; 
                                
        case _SYSTEMVAR2:       strcpy(cTextLine1,">Height f-borne ");
                                strcpy(cTextLine2," Height f-assist"); break; 
                                
        case _SYSTEMVAR3:       strcpy(cTextLine1,">Height f-assist");
                                strcpy(cTextLine2," AOA f-assist   "); break; 
                                
        case _SYSTEMVAR4:       strcpy(cTextLine1,">AOA f-assist   ");
                                strcpy(cTextLine2," Back           "); break;
                                                                                                 
//////////////////////////////////////////////////////////////////////////////////////
// menulayer 2 settings                                                             //
//////////////////////////////////////////////////////////////////////////////////////
        case _SYSTEMVARSELECT0: strcpy(cTextLine1," Agree to change");
                                strcpy(cTextLine2,">Roll angle     "); break;
                                
        case _SYSTEMVARSELECT1: strcpy(cTextLine1," Agree to change");
                                strcpy(cTextLine2,">Pitch angle    "); break;
                                
        case _SYSTEMVARSELECT2: strcpy(cTextLine1," Agree to change");
                                strcpy(cTextLine2,">Take-off speed "); break;
                                
        case _SYSTEMVARSELECT3: strcpy(cTextLine1," Agree to change");
                                strcpy(cTextLine2,">Height f-borne "); break;
                                
        case _SYSTEMVARSELECT4: strcpy(cTextLine1," Agree to change");
                                strcpy(cTextLine2,">Height f-assist"); break;
                                
        case _SYSTEMVARSELECT5: strcpy(cTextLine1," Agree to change");
                                strcpy(cTextLine2,">AOA f-assist   "); break;

//////////////////////////////////////////////////////////////////////////////////////
// menulayer 2 settings                                                             //
//////////////////////////////////////////////////////////////////////////////////////                                
        case _MUTATESYSTEMVAR0: svSoF.cShowValue(_MAXROLL);
                                strcpy(cTextLine1," max roll angle ");
                                strcpy(cTextLine2,"     ");
                                strcat(cTextLine2, svSoF.getValue());
                                strcat(cTextLine2,"\xDF"); 
                                vFillString2(); break; 
                                
        case _MUTATESYSTEMVAR1: svSoF.cShowValue(_MINPITCH);
                                strcpy(cTextLine1," min pitch angle");
                                strcpy(cTextLine2,"     ");
                                strcat(cTextLine2, svSoF.getValue());
                                strcat(cTextLine2,"\xDF"); 
                                vFillString2(); break; 
                                
        case _MUTATESYSTEMVAR2: svSoF.cShowValue(_MAXPITCH);
                                strcpy(cTextLine1," max pitch angle ");
                                strcpy(cTextLine2,"     ");
                                strcat(cTextLine2, svSoF.getValue());
                                strcat(cTextLine2,"\xDF"); 
                                vFillString2(); break;
                                
        case _MUTATESYSTEMVAR3: svSoF.cShowValue(_TAKEOFFSPEED);
                                strcpy(cTextLine1,"  max T-O speed  ");
                                strcpy(cTextLine2,"     ");
                                strcat(cTextLine2, svSoF.getValue());
                                strcat(cTextLine2,"knots"); 
                                vFillString2(); break; 
                                
        case _MUTATESYSTEMVAR4: svSoF.cShowValue(_HEIGHTFOILBORNE);
                                strcpy(cTextLine1," foilborne height");
                                strcpy(cTextLine2,"     ");
                                strcat(cTextLine2, svSoF.getValue());
                                strcat(cTextLine2,"cm."); 
                                vFillString2(); break;
                                
        case _MUTATESYSTEMVAR5: svSoF.cShowValue(_HEIGHTFOILASSIST);
                                strcpy(cTextLine1," f-assist height ");
                                strcpy(cTextLine2,"     ");
                                strcat(cTextLine2, svSoF.getValue());
                                strcat(cTextLine2,"cm."); 
                                vFillString2(); break;
                                
        case _MUTATESYSTEMVAR6: svSoF.cShowValue(_AOAFOILASSIST);
                                strcpy(cTextLine1," AOA foil assist ");
                                strcpy(cTextLine2,"     ");
                                strcat(cTextLine2, svSoF.getValue());
                                strcat(cTextLine2,"\xDF"); 
                                vFillString2(); break;                                                                                                                                                                                                                                                                                                                                            
                               
//////////////////////////////////////////////////////////////////////////////////////
// Multiple used screens                                                            //
//////////////////////////////////////////////////////////////////////////////////////         
        case _BACK:             strcpy(cTextLine1,">Back           ");
                                strcpy(cTextLine2," Home           "); break;
                                 
        case _HOME:             strcpy(cTextLine1," Back           ");
                                strcpy(cTextLine2,">Home           "); break; 
                                                                              
//////////////////////////////////////////////////////////////////////////////////////
// CAN messages                                                                     //
////////////////////////////////////////////////////////////////////////////////////// 
                        
        case _FOILBORNE:        strcpy(cTextLine1," Solar on Foils ");
                                strcpy(cTextLine2," FOILBORNE mode "); break;
                                
        case _FOILASSIST:       strcpy(cTextLine1," Solar on Foils ");
                                strcpy(cTextLine2," FOILASSIST mode"); break;
                                
        case _HOMESCREEN:       strcpy(cTextLine1," Solar on Foils ");
                                strcpy(cTextLine2,">Home           "); break;                                              
                                
        case _PROGRESS:         strcpy(cTextLine1," Solar on Foils ");
                                strcpy(cTextLine2,"work in progress"); break;                        

//////////////////////////////////////////////////////////////////////////////////////
// CAN messages                                                                     //
//////////////////////////////////////////////////////////////////////////////////////                         
        case _CANINIT:          strcpy(cTextLine1," Solar on Foils ");
                                strcpy(cTextLine2," CAN INITIALIZE "); break;
                            
        case _CANOK:            strcpy(cTextLine2,"   System OK    "); break;
         
        case _CANID101OK:       strcpy(cTextLine1,"    PORT FOIL   "); 
                                strcpy(cTextLine2,"     CAN OK     "); break;
        case _CANID102OK:       strcpy(cTextLine1,"   STARB FOIL   "); 
                                strcpy(cTextLine2,"     CAN OK     "); break;
        case _CANID201OK:       strcpy(cTextLine1,"   PORT HEIGHT  "); 
                                strcpy(cTextLine2,"     CAN OK     "); break;
        case _CANID202OK:       strcpy(cTextLine1,"  STARB HEIGHT  "); 
                                strcpy(cTextLine2,"     CAN OK     "); break;
        case _CANID205OK:       strcpy(cTextLine1,"    GYRO/GPS    "); 
                                strcpy(cTextLine2,"     CAN OK     "); break;
        case _CANID1001OK:      strcpy(cTextLine1,"    EXTERN UI   "); 
                                strcpy(cTextLine2,"     CAN OK     "); break;
        case _CANID101FAIL:     strcpy(cTextLine1,"    PORT FOIL   "); 
                                strcpy(cTextLine2,"    CAN FAIL    "); break;
        case _CANID102FAIL:     strcpy(cTextLine1,"   STARB FOIL   "); 
                                strcpy(cTextLine2,"    CAN FAIL    "); break;
        case _CANID201FAIL:     strcpy(cTextLine1,"   PORT HEIGHT  "); 
                                strcpy(cTextLine2,"    CAN FAIL    "); break;
        case _CANID202FAIL:     strcpy(cTextLine1,"  STARB HEIGHT  "); 
                                strcpy(cTextLine2,"    CAN FAIL    "); break;
        case _CANID205FAIL:     strcpy(cTextLine1,"    GYRO/GPS    "); 
                                strcpy(cTextLine2,"    CAN FAIL    "); break;
        case _CANID1001FAIL:    strcpy(cTextLine1,"    EXTERN UI   "); 
                                strcpy(cTextLine2,"    CAN FAIL    "); break;
                            
        case _CANFAIL:          strcpy(cTextLine2,"   System FAIL  "); break;
                            
        case _CANNORESPONSE:    strcpy(cTextLine2," No CAN responce"); break;
        
        case _PULSE_IS:         strcpy(cTextLine1,"Pulse is:       ");
//                                char *intStr = itoa(uiCounter);
                                //string str = string(intStr); 
//                                strcpy(cTextLine2, intStr);  // about to test
        break;
        
//////////////////////////////////////////////////////////////////////////////////////
// IMU messages                                                                     //
//////////////////////////////////////////////////////////////////////////////////////         
        case _IMUREADY:         strcpy(cTextLine1,"MPU9150 is ready"); break; 
        
        case _IMUFAIL:          strcpy(cTextLine1,"MPU9150init fail"); break;
          
//////////////////////////////////////////////////////////////////////////////////////
// Test screens                                                                     //
//////////////////////////////////////////////////////////////////////////////////////         
        case _ROLLTEST:         svSoF.cShowValue(_ROLL);
                                strcpy(cTextLine1," Confirm to end ");
                                strcpy(cTextLine2,"Roll: ");
                                if(svSoF.iGetRollPolarity()!= 0) strcat(cTextLine2,"+");
                                else strcat(cTextLine2,"-");
                                strcat(cTextLine2, svSoF.getValue());
                                strcat(cTextLine2,"\xDF"); 
                                vFillString2(); break;  
                                
        case _PITCHTEST:        svSoF.cShowValue(_PITCH);
                                strcpy(cTextLine1," Confirm to end ");
                                strcpy(cTextLine2,"Pitch:");
                                if(svSoF.iGetPitchPolarity()!= 0) strcat(cTextLine2,"+");
                                else strcat(cTextLine2,"-");
                                strcat(cTextLine2, svSoF.getValue());
                                strcat(cTextLine2,"\xDF"); 
                                vFillString2(); break;
                                
        case _HEIGHTTEST:       svSoF.cShowValue(_PHEIGHT);
                                strcpy(cTextLine1," Confirm to end ");
                                strcpy(cTextLine2,"Port:");
                                strcat(cTextLine2, svSoF.getValue());
                                strcat(cTextLine2," cm.");
                                vFillString2(); break;
                                            
        case _SHOWHEIGHTFB:     svSoF.cShowValue(_HEIGHTFOILBORNE);
                                strcpy(cTextLine1," Confirm to end ");
                                strcpy(cTextLine2,"Height:"); 
                                strcat(cTextLine2, svSoF.getValue());
                                strcat(cTextLine2," cm."); 
                                vFillString2(); break;     
    }   // End switch case    
    if(strlen(cTextLine1) > 18) strcpy(cTextLine1," Line overflow  ");
    if(strlen(cTextLine2) > 18) strcpy(cTextLine2," Line overflow  ");
}

//////////////////////////////////////////////////////////////////////////////////////
// select menu screens                                                              //
//////////////////////////////////////////////////////////////////////////////////////
void Menu::vSelectMenu(MENU_t m)
{
    menu = m;
    switch(menu)
    {
        case _MENU0_0:              mLCDMenu.vShowScreen(_INIT); nextMenu = _MENU0_1; break;
        
        case _MENU0_1:              mLCDMenu.vShowScreen(_STANDBY); nextMenu =  prevMenu = confMenu = _MENU0_2; break;
        
        case _MENU0_2:              mLCDMenu.vShowScreen(_SETTINGS0); nextMenu = _MENU0_3; prevMenu = _MENU0_4; confMenu = _MENU1_20; break;
        
        case _MENU0_3:              mLCDMenu.vShowScreen(_SETTINGS1); nextMenu = _MENU0_4; prevMenu = _MENU0_2; confMenu = _MENU1_31; break;
        
        case _MENU0_4:              mLCDMenu.vShowScreen(_SETTINGS2); nextMenu = _MENU0_2; prevMenu = _MENU0_3; confMenu = _MENU1_4; break;
        
        case _MENU1_20:             mLCDMenu.vShowScreen(_SYSTEMVAR0); nextMenu = _MENU1_21; prevMenu = _MENU1_20; confMenu = _MENU2_20; break;
        
        case _MENU1_21:             mLCDMenu.vShowScreen(_SYSTEMVAR1); nextMenu = _MENU1_22; prevMenu = _MENU1_20; confMenu = _MENU2_21; break;
        
        case _MENU1_22:             mLCDMenu.vShowScreen(_SYSTEMVAR2); nextMenu = _MENU1_23; prevMenu = _MENU1_21; confMenu = _MENU2_22; break;
                     
        case _MENU1_23:             mLCDMenu.vShowScreen(_SYSTEMVAR3); nextMenu = _MENU1_24; prevMenu = _MENU1_22; confMenu = _MENU2_23; break;
        
        case _MENU1_24:             mLCDMenu.vShowScreen(_SYSTEMVAR4); nextMenu = _BACKBACK; prevMenu = _MENU1_23; confMenu = _MENU2_24; break;
        
        case _MENU2_20:             mLCDMenu.vShowScreen(_SYSTEMVARSELECT0); nextMenu = _MENU2_21; prevMenu = _MENU2_20; confMenu = _MENU3_20; valueToChange = _MAXROLL; break;
        
        case _MENU2_21:             mLCDMenu.vShowScreen(_SYSTEMVARSELECT1); nextMenu = _MENU2_22; prevMenu = _MENU2_20; confMenu = _MENU3_21; valueToChange = _MINPITCH; break;
        
        case _MENU2_22:             mLCDMenu.vShowScreen(_SYSTEMVARSELECT2); nextMenu = _MENU2_23; prevMenu = _MENU2_21; confMenu = _MENU3_23; valueToChange = _TAKEOFFSPEED; break;
        
        case _MENU2_23:             mLCDMenu.vShowScreen(_SYSTEMVARSELECT3); nextMenu = _MENU2_24; prevMenu = _MENU2_22; confMenu = _MENU3_24; valueToChange = _HEIGHTFOILBORNE; break;
        
        case _MENU2_24:             mLCDMenu.vShowScreen(_SYSTEMVARSELECT4); nextMenu = _MENU2_25; prevMenu = _MENU2_23; confMenu = _MENU3_25; valueToChange = _HEIGHTFOILASSIST; break;
        
        case _MENU2_25:             mLCDMenu.vShowScreen(_SYSTEMVARSELECT5); nextMenu = _BACKBACK; prevMenu = _MENU2_24; confMenu = _MENU3_26; valueToChange = _AOAFOILASSIST; break;
        
        // system variabele aanpassen
        case _MENU3_20:             bMenu = false; mLCDMenu.vShowScreen(_MUTATESYSTEMVAR0); confMenu = _MENU2_20; break;
        
        case _MENU3_21:             bMenu = false; mLCDMenu.vShowScreen(_MUTATESYSTEMVAR1); confMenu = _MENU3_22; valueToChange = _MAXPITCH; break;
        
        case _MENU3_22:             bMenu = false; mLCDMenu.vShowScreen(_MUTATESYSTEMVAR2); confMenu = _MENU2_21; break;
        
        case _MENU3_23:             bMenu = false; mLCDMenu.vShowScreen(_MUTATESYSTEMVAR3); confMenu = _MENU2_22; break;
        
        case _MENU3_24:             bMenu = false; mLCDMenu.vShowScreen(_MUTATESYSTEMVAR4); confMenu = _MENU2_23; break;
        
        case _MENU3_25:             bMenu = false; mLCDMenu.vShowScreen(_MUTATESYSTEMVAR5); confMenu = _MENU2_24; break;
        
        case _MENU3_26:             bMenu = false; mLCDMenu.vShowScreen(_MUTATESYSTEMVAR6); confMenu = _MENU2_25; break;
        
        
        case _MENU1_4:              mLCDMenu.vShowScreen(_PROGRESS); nextMenu = _MENU0_2; prevMenu = _MENU0_3; confMenu = _MENU1_20; break;
        
        case _MENU1_31:             mLCDMenu.vShowScreen(_ROLLTEST); nextMenu = _MENU1_32; prevMenu = _BACKHOME; confMenu = _MENU1_31; break;
        
        case _MENU1_32:             mLCDMenu.vShowScreen(_PITCHTEST); nextMenu = _MENU1_33; prevMenu = _MENU1_31; confMenu = _MENU1_32; break;
        
        case _MENU1_33:             mLCDMenu.vShowScreen(_SHOWHEIGHTFB); bReadHeight = false; nextMenu = _MENU1_34; prevMenu = _MENU1_32; confMenu = _MENU1_33; break;
        
        case _MENU1_34:             mLCDMenu.vShowScreen(_HEIGHTTEST); bReadHeight = true; nextMenu = _BACKHOME; prevMenu = _MENU1_33; confMenu = _MENU1_34; break;
        // Todo confMenu to previous menu layer
        case _BACKBACK:             mLCDMenu.vShowScreen(_BACK); bReadHeight = false; nextMenu = _BACKHOME; prevMenu = backToFrom; confMenu = _MENU0_2; break;
        
        case _BACKHOME:             mLCDMenu.vShowScreen(_HOME); bReadHeight = false; nextMenu = _BACKHOME; prevMenu = _BACKBACK; confMenu = _MENU0_2; break;
        
    }//end switch
}

