//////////////////////////////////////////////////////////////////////////////////////
//                                                                                  //
//		File        : LCD_I2C.h                                                     //
//		Version     : 0.2                                                           //
//		Date        : 25 march 2015                                                 //
//		Author      : Dany Brugman                                                  //
//		Comment     : Function to write data to a 2x16 LCD by I2C                   //
//                    using a MCP23017 port expander.                               //
//																					//
//		Changelog   :																//
//		Date:			Name:		Comment:										//
//		25/03/2015		DNB         First version	    							//
//      25/03/2015      DNB         Implementation LCD_printPos                     //
//		26/06/2015		DNB			Rebuild LCD_I2C to class						//
//                                                                                  //
//////////////////////////////////////////////////////////////////////////////////////

#ifndef ____LCD_I2C__
#define ____LCD_I2C__

//////////////////////////////////////////////////////////////////////////////////////
// includes                                                                         //
//////////////////////////////////////////////////////////////////////////////////////
#include <stdio.h>
#include "MCP23017.h"

//////////////////////////////////////////////////////////////////////////////////////
// class                                                                            //
//////////////////////////////////////////////////////////////////////////////////////
class LCD_I2C
{
    private:
        // resources
        I2C i2c;
        MCP23017 mcp23017;
        
        // variable
        uint32_t uiCounter;
        
        char deviceAdress;
        char buffer_GPIOB;
                
        bool bError;
        
    public:
        // Constructor
        LCD_I2C(PinName, PinName, char);
        // Destructor
        ~LCD_I2C();
        
//////////////////////////////////////////////////////////////////////////////////////
// base functions                                                                   //
//////////////////////////////////////////////////////////////////////////////////////
void vLCD_delay_I2C (unsigned int t_delay);             // delay up to 65535 ticks
void vLCD_cmd_I2C   (unsigned char commando);           // send commando to LCD
void vLCD_data_I2C  (unsigned char data);               // write single character to LCD
void vLCD_init_I2C  (void);                            	// init LCD
void vLCD_clear_I2C	(void);								// clear LCD

//////////////////////////////////////////////////////////////////////////////////////
// write functions                                                                  //
////////////////////////////////////////////////////////////////////////////////////// 
void vLCD_print_I2C 	(unsigned char *string, unsigned char line);						// write a string to certain line       
void vLCD_printLine_I2C (unsigned char *string, unsigned char line);						// write a string to certain line
void vLCD_printPos_I2C 	(unsigned char *sting, unsigned char line, unsigned char character);// write a string to certain line
void vLCD_printInt_I2C 	(int value, unsigned char line, unsigned char character);			// write a integer to certain line

//////////////////////////////////////////////////////////////////////////////////////
// update LCD                                                                 		//
//////////////////////////////////////////////////////////////////////////////////////
void vLCD_update (void); 																	// update LCD 
 
        
};//end class


//////////////////////////////////////////////////////////////////////////////////////
// original functions                                                               //
//////////////////////////////////////////////////////////////////////////////////////
/*
void vLCD_delay_I2C (unsigned int t_delay);                          	// delay up to 65535 ticks
void vLCD_cmd_I2C   (unsigned char commando);                        	// send commando to LCD
void vLCD_data_I2C  (unsigned char data);                            	// write single character to LCD
void vLCD_init_I2C  (void);                                          	// init LCD
void vLCD_clear_I2C	(void);												// clear LCD
// write a string to certain line
void vLCD_printLine_I2C (unsigned char *string, unsigned char line);
// write a string to certain line
void vLCD_printPos_I2C (unsigned char *sting, unsigned char line, unsigned char character);
// write a integer to certain line
void vLCD_printInt_I2C (int value, unsigned char line, unsigned char character);
// update lcd
void vLCD_update (void);
*/

#endif /* defined(____LCD_I2C__) */

//////////////////////////////////////////////////////////////////////////////////////
// EOF                                                                              //
//////////////////////////////////////////////////////////////////////////////////////