#ifndef STEPPER_H_INCLUDED
#define STEPPER_H_INCLUDED

#include "mbed.h"

class Stepper
{
    private:
        // variable
        uint32_t counter;
        uint32_t offTimeCounter;
        uint32_t uiInitRampDown;
        
        bool offTime;
        bool bRampUp;
        bool bRampDown;
        
    public:
        // Constructor
        Stepper();
        // Destructor
        ~Stepper();
        
        // Gets
        uint32_t iGetStepCount(void);
        uint32_t iGetOffTimeCount(void);
        bool bGetoffTime(void);
        bool bGetRampUp(void);
        bool bGetRampDown(void);        

        // Sets
        void vSetStepCount(uint32_t);
        void vSetOffTimeCount(uint32_t);

        // Other functions
        void vDecreaseStepCount(void);
        void vIncreaseStepCount(void);
        void vDecreaseOffTimeCount(void);       //ramp up
        void vIncreaseOffTimeCount(void);       //ramp down
        void vResetOffTimeCount(void);
};
#endif
