
#include "Stepper.h"

// Contructor
Stepper::Stepper() : 
        counter(0),
        bRampUp(false),
        bRampDown(false)
        {};

Stepper::~Stepper()
{
};

//////////////////////////////////////////////////////////////////////////////////////
// set's                                                                            //
////////////////////////////////////////////////////////////////////////////////////// 
void Stepper::vSetStepCount(uint32_t Value)
{
    if (Value <= 400) uiInitRampDown = Value/2; 
    else uiInitRampDown = 400;
    counter = Value;    
}

void Stepper::vSetOffTimeCount(uint32_t Value)
{
    offTimeCounter = Value;   
}

void Stepper::vResetOffTimeCount(void)
{
    offTimeCounter = 1500;              // max ramp up/down = 700us
    offTime = true;
    bRampUp = true;
    bRampDown = false;
}

//////////////////////////////////////////////////////////////////////////////////////
// get's                                                                            //
////////////////////////////////////////////////////////////////////////////////////// 
uint32_t Stepper::iGetStepCount(void)
{
    return counter;
}

uint32_t Stepper::iGetOffTimeCount(void)
{
    if (counter == uiInitRampDown) {bRampDown = true; bRampUp = false;}
    return offTimeCounter;
}

bool Stepper::bGetoffTime(void)
{
    return offTime;
}

bool Stepper::bGetRampUp(void)
{
    return bRampUp;
}

bool Stepper::bGetRampDown(void)
{
    return bRampDown;
} 

//////////////////////////////////////////////////////////////////////////////////////
// decreases                                                                        //
////////////////////////////////////////////////////////////////////////////////////// 
void Stepper::vDecreaseStepCount(void)
{
    counter--;
}

void Stepper::vDecreaseOffTimeCount(void)
{
    if(offTimeCounter >= 800)                           // while ramp up isn't complete 
    {
        offTimeCounter--;
        offTime = false;                                // ramp up complete
        if (offTimeCounter == 800) bRampUp = false;
    }
}

void Stepper::vIncreaseOffTimeCount(void)
{
    if(offTimeCounter <= 1500)                          // while ramp down isn't complete 
    {
        offTimeCounter++;  
        //if (offTimeCounter == 1500) bRampUp = false;    // ramp down complete
    }
}

//////////////////////////////////////////////////////////////////////////////////////
// increases                                                                        //
////////////////////////////////////////////////////////////////////////////////////// 
void Stepper::vIncreaseStepCount(void)
{
    counter++;
}

