//////////////////////////////////////////////////////////////////////////////////////
//                                                                                  //
//      File        : main.cpp                                                      //
//      Version     : 0.1                                                           //
//      Initial     : 17 June 2015                                                  //
//      Author      : Dany Brugman                                                  //
//      Comment     : Extern UI using CANbus                                        //
//                                                                                  //
//                                                                                  //
//      Changelog   :                                                               //
//      Date:           Name:       Comment:                                        //
//      17/06/2015      DNB         First version                                   //
//                                                                                  //
//////////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////////
// includes                                                                         //
//////////////////////////////////////////////////////////////////////////////////////
#include "mbed.h"
#include "PinDetect.h"
#include "ExtUI.h"

//////////////////////////////////////////////////////////////////////////////////////
// defines                                                                          //
////////////////////////////////////////////////////////////////////////////////////// 
#define DEVICE_ID   20
#define ACTIVE_ACK  255
#define NEW_HEIGHT  1020
#define REQ_STATUS  2006

//////////////////////////////////////////////////////////////////////////////////////
// interrupts                                                                       //
//////////////////////////////////////////////////////////////////////////////////////
Ticker  ticker;
Ticker  tActiveLedOn;
Ticker  tled2on;

Timeout tActiveLedOff;
Timeout tled2off;

//////////////////////////////////////////////////////////////////////////////////////
// port declaration                                                                 //
//////////////////////////////////////////////////////////////////////////////////////
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led4(LED4);
DigitalOut activeLed(p26);
DigitalOut emergencyLed(p25);

//BusOut heightLeds (p13, p14, p5, p6, p7);

//PwmOut Red(p21);
//PwmOut Green(p22);
//PwmOut Blue(p23);

CAN CANBus(p30, p29);

PinDetect  SW_UP( p12 );
PinDetect  SW_DWN( p8 );
PinDetect  SW_MFB( p11 );

ExtUI eSOFUI;

Serial debug(USBTX, USBRX);

//////////////////////////////////////////////////////////////////////////////////////
// global variables                                                                 //
//////////////////////////////////////////////////////////////////////////////////////
char counter = 0;
char cMessage, cStatus;

int i;
int iHeight = 0;

//const uint32_t cuLut[6] = {0x00, 0x01, 0x02, 0x04, 0x08, 0x10};   /moved to class

//////////////////////////////////////////////////////////////////////////////////////
// functions declarations                                                           //
//////////////////////////////////////////////////////////////////////////////////////



//////////////////////////////////////////////////////////////////////////////////////
// functions                                                                        //
//////////////////////////////////////////////////////////////////////////////////////


 
void send() 
{
    if(CANBus.write(CANMessage(1226, &counter, 1))) 
    {
        counter++;
    } 
}

/*void heightIncrease(void)
{
    if (iHeight < 5) iHeight++;
    heightLeds.write(cuLut[iHeight]);
}

void heightDecrease(void)
{
    if (iHeight != 0) iHeight--;
    heightLeds.write(cuLut[iHeight]);
}*/

void switchUpPressed(void){
    eSOFUI.heightIncrease();
    debug.printf("\033[10;10fTarget height:%i\r\n", eSOFUI.getTargetHeight());
}

void switchDownPressed(void){
    eSOFUI.heightDecrease();
    debug.printf("\033[10;10fTarget height:%i\r\n", eSOFUI.getTargetHeight());
}

void switchPressed(void){
    //test();
    //cMessage = 0xFF;
    //CANBus.write(CANMessage(100, &cMessage, 1));
    //debug.printf("Switch pressed: %d  \r\n", cMessage);
}

void switchReleased(void){
    cMessage = 0x00;
    CANBus.write(CANMessage(100, &cMessage, 1));
    //debug.printf("Switch released: %d \r\n", cMessage);
}



//////////////////////////////////////////////////////////////////////////////////////
// Blink functions                                                                  //
//////////////////////////////////////////////////////////////////////////////////////
void tActiveLedOff_cb(void) 
{
    activeLed = 0;
}
 
void tActiveLedOn_cb(void) 
{
    activeLed = 1;
    tActiveLedOff.detach();
    tActiveLedOff.attach(&tActiveLedOff_cb, 0.05);
}

void tled2off_cb(void) 
{
    //Green = 0.0f;
    led1 = 0;
}
 
void tled2on_cb(void) 
{
    //Green = 0.1f;
    led1 = 1;
    tled2off.detach();
    tled2off.attach(&tled2off_cb, 0.05);
}

//////////////////////////////////////////////////////////////////////////////////////
// main loop                                                                        //
//////////////////////////////////////////////////////////////////////////////////////
int main() {
    debug.printf("\033[2J");
    debug.printf("\033[9;10fDevice ID:%i\r\n", DEVICE_ID);
    
    activeLed = 1;
    //Green = 0.2f;
//////////////////////////////////////////////////////////////////////////////////////
// schedule led events                                                              //
//////////////////////////////////////////////////////////////////////////////////////    
    tActiveLedOff.attach(&tActiveLedOn_cb, 0.05);
    tActiveLedOn.attach(&tActiveLedOn_cb, 2);
    tled2off.attach(&tled2on_cb, 0.05);
    tled2on.attach(&tled2on_cb, 1);
//////////////////////////////////////////////////////////////////////////////////////
// switch interrupts                                                                //
//////////////////////////////////////////////////////////////////////////////////////    
    // MFB switch 
    SW_MFB.mode( PullDown );
    SW_MFB.attach_asserted( &switchPressed );
    SW_MFB.attach_deasserted( &switchReleased );
    SW_MFB.setSampleFrequency();                   // Defaults to 20ms.
    // UP switch 
    SW_UP.mode( PullDown );
    SW_UP.attach_asserted( &switchUpPressed );
    SW_UP.setSampleFrequency();                   // Defaults to 20ms.
    // DOWN switch 
    SW_DWN.mode( PullDown );
    SW_DWN.attach_asserted( &switchDownPressed );
    SW_DWN.setSampleFrequency();                   // Defaults to 20ms.
    
    //Red.period_ms(10);
    //Green.period_ms(10);
    //Blue.period_ms(10);
    
    CANBus.frequency(250000);
    CANMessage msg;
    //char Value;
    
    //Blue    = 0.4f;
    //Red     = 0.4f;
    //Green   = 0.2f;
    
    while(1) 
    { 
        if(CANBus.read(msg))
        {
            switch(msg.id)
            {   // Send system status if MainModule requests
                case REQ_STATUS:
                            cStatus = 0xFF;                                     // OK
                            if(msg.data[0] == 00) CANBus.write(CANMessage(DEVICE_ID, &cStatus, 1));
                            wait_us(100);
                            break;
                // process stepper data direction/steps            
                case DEVICE_ID:
                            if(msg.data[0] != 00) 
                            {
                                tActiveLedOn.attach(&tActiveLedOn_cb, 0.5);   
                            }
                            cStatus = ACTIVE_ACK;
                            CANBus.write(CANMessage(DEVICE_ID, &cStatus, 1));   // reply message received and executed
                            tActiveLedOn.attach(&tActiveLedOn_cb, 2);                     // indicate active
                            break;
                
                case NEW_HEIGHT:
                            eSOFUI.setTargetHeight((uint32_t) msg.data[0]);
                
                // just dump received message (debug)
                default:    
                            debug.printf("Message id: %d\r\n", msg.id);
                            debug.printf("Message length: %d\r\n", msg.len);
                            for (i=0; i < msg.len; i++)
                            {
                                debug.printf("Message %d received: %d\r\n", i, msg.data[i]);
                            }
                            break;
            }
        }
        wait_ms(500);
    }
}

//////////////////////////////////////////////////////////////////////////////////////
// EOF                                                                              //
//////////////////////////////////////////////////////////////////////////////////////
