#ifndef EXTUI_H_INCLUDED
#define EXTUI_H_INCLUDED

#include "mbed.h"

//Solar on Foils display screens
enum BUTTON_t
{
    _EMERG_LANDING = 0,  // Initialize screen
    _STANDBY,            // Standby screen
    _ACTIVE             // Active screen
};

// SOF LUT
const uint32_t cuLut[6] = {0x00, 0x01, 0x03, 0x07, 0x0F, 0x1F};

class ExtUI
{
    private:
        // Resource
        BusOut heightLeds;
        
        PwmOut      Red;
        PwmOut      Green;
        PwmOut      Blue;   
    
        // variable
        BUTTON_t buttonStatus;
        
        int iHeight;
        uint32_t uiCounter;
        uint32_t uiTargetHeight;
        
        char cMessage;
                
        bool bError;
        
    public:
        // Constructor
        ExtUI();
        // Destructor
        ~ExtUI();
        
        // Gets
        uint32_t getTargetHeight(void);
        
        // Sets
        int setTargetHeight(uint32_t);

        // Other functions
        void init(void);
        void heightIncrease(void);
        void heightDecrease(void);
        void vUpdatextUI(void);
        
};
#endif
