//////////////////////////////////////////////////////////////////////////////////////
//                                                                                  //
//      File        : ExtUI.cpp                                                     //
//      Version     : 0.1                                                           //
//      Initial     : 19 June 2015                                                  //
//      Author      : Dany Brugman                                                  //
//      Comment     : externe UI class                                              //
//                                                                                  //
//                                                                                  //
//      Changelog   :                                                               //
//      Date:           Name:       Comment:                                        //
//      19/06/2015      DNB         First version                                   //
//                                                                                  //
//////////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////////
// includes                                                                         //
//////////////////////////////////////////////////////////////////////////////////////
#include "ExtUI.h"

//////////////////////////////////////////////////////////////////////////////////////
// defines                                                                          //
//////////////////////////////////////////////////////////////////////////////////////
#define NEW_HEIGHT  1020

//////////////////////////////////////////////////////////////////////////////////////
// constructor                                                                      //
//////////////////////////////////////////////////////////////////////////////////////
ExtUI::ExtUI() : 
        heightLeds (p13, p14, p5, p6, p7), 
        Red(p21),
        Green(p22),
        Blue(p23),
        iHeight(1)
{
    init();
};

ExtUI::~ExtUI()
{
};

extern CAN CANBus;


void ExtUI::init(void)
{
    Red.period_ms(10);
    Green.period_ms(10);
    Blue.period_ms(10);
    Red = 0.2f; wait(0.2);
    Red = 0.0f; Green = 0.2f; wait(0.2);
    Green = 0.0f; Blue = 0.2f;
}

uint32_t ExtUI::getTargetHeight(void)
{
    return uiTargetHeight;
}

int ExtUI::setTargetHeight(uint32_t Value)
{
    if ((Value % 5 == 0)&&(Value <= 30)) 
    {
        uiTargetHeight = Value;
        vUpdatextUI();
        return 1;
    } 
    else return 0;  //error out of range   
}

void ExtUI::heightIncrease(void)
{
    if (iHeight !=0) iHeight = getTargetHeight()/5;
    if (iHeight < 6) iHeight++;
    cMessage = (char) (iHeight * 5);
    CANBus.write(CANMessage(NEW_HEIGHT, &cMessage, 1)); 
    //setTargetHeight(iHeight * 5);
    vUpdatextUI();
    //heightLeds.write(cuLut[iHeight-1]);
}

void ExtUI::heightDecrease(void)
{
    iHeight = getTargetHeight()/5;
    if (iHeight > 1) iHeight--;
    cMessage = (char) (iHeight * 5);
    CANBus.write(CANMessage(NEW_HEIGHT, &cMessage, 1));
    //setTargetHeight(iHeight * 5);
    vUpdatextUI();
    //heightLeds.write(cuLut[iHeight-1]);
    //printf("iHeight: %i\r\n", iHeight);
}

void ExtUI::vUpdatextUI(void)
{
    iHeight = getTargetHeight()/5;
    heightLeds.write(cuLut[iHeight-1]);
}

 

 