#ifndef SENSOR_H_INCLUDED
#define SENSOR_H_INCLUDED

#include "mbed.h"
#include "circular_buffer.h"

class Sensor
{
    private:
        // Resource
          
    
        // variable
        uint32_t uiHeight;
        uint32_t uiCounter;
        
        float fValue, fDistance;
        float fAverageDistance;
        
        char cValue[4];
        char cMessage;
                
        bool bClearToSend;
        bool bError;
        
        
    public:
        // Constructor
        Sensor();
        // Destructor
        ~Sensor();
        
        // Gets
        uint32_t getHeight(void);
        
        // Sets
        int setHeight(uint32_t);
        void setClearToSend(bool);

        // Other functions
        void init(void);
        void vMeasureHeight(void);
        float vAverageValue(void);
        void itoa( uint32_t, char *);
        char* getValue(void); 
                
};
#endif