//////////////////////////////////////////////////////////////////////////////////////
//                                                                                  //
//      File        : ExtUI.cpp                                                     //
//      Version     : 0.1                                                           //
//      Initial     : 24 June 2015                                                  //
//      Author      : Dany Brugman                                                  //
//      Comment     : sensor class                                                  //
//                                                                                  //
//                                                                                  //
//      Changelog   :                                                               //
//      Date:           Name:       Comment:                                        //
//      24/06/2015      DNB         First version                                   //
//                                                                                  //
//////////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////////
// includes                                                                         //
//////////////////////////////////////////////////////////////////////////////////////
#include "sensor.h"

//////////////////////////////////////////////////////////////////////////////////////
// defines                                                                          //
//////////////////////////////////////////////////////////////////////////////////////
#define NEW_HEIGHT      203

//////////////////////////////////////////////////////////////////////////////////////
// constructor                                                                      //
//////////////////////////////////////////////////////////////////////////////////////
Sensor::Sensor() : 
        uiCounter(0),
        bClearToSend(0)
{
    init();
};

Sensor::~Sensor()
{
};

extern Serial debug;
extern CAN CANBus;
extern AnalogIn sensorPort;

circular_buffer<float> cbHeightBuffer(10);
//////////////////////////////////////////////////////////////////////////////////////
// initialisation                                                                   //
//////////////////////////////////////////////////////////////////////////////////////
void Sensor::init(void)
{
    
}

void Sensor::vMeasureHeight(void)
{
    fValue = sensorPort.read();
    fDistance = (((fValue- 0.18f)* 122.22f) + 12);
    cbHeightBuffer.push_back(fDistance);
    uiHeight = (uint32_t) fDistance;
    itoa(fDistance, cValue);
    //cMessage = getValue();
    if (bClearToSend)
    {    
        CANBus.write(CANMessage(NEW_HEIGHT, getValue(), 1));
        debug.printf("Clear to send\t");
    }
    debug.printf("Sensor value int: %i\t", uiHeight);
    debug.printf("send data: %c\r\n", getValue());
}

float Sensor::vAverageValue(void)
{
    int i;
    int size = cbHeightBuffer.get_size();
    for(i=0; i < size; i++) 
    {
        fAverageDistance += cbHeightBuffer.front(); 
    }
    fAverageDistance = fAverageDistance/size;
    return fAverageDistance;
}

void Sensor::setClearToSend(bool Status)
{
    bClearToSend = Status;
}

//////////////////////////////////////////////////////////////////////////////////////
// prep value                                                                       //
//////////////////////////////////////////////////////////////////////////////////////
void Sensor::itoa( uint32_t value, char *str)
{   
   int i,j;
   char temp[4];
   for(i=0; value > 0; i++){    
       str[i] = value%10+'0';
       value=value/10;
    }
    for(j=0;i>=0;j++,i--){
        temp[j]=str[i-1];
    }
    for(i=0;i<j;i++){
        str[i]=temp[i];
    }
    if(strcmp(str,"")== 0) str[0] = '0';    
}

//////////////////////////////////////////////////////////////////////////////////////
// get value                                                                        //
//////////////////////////////////////////////////////////////////////////////////////
char* Sensor::getValue(void) 
{
     static char* pValue;
     pValue = cValue;
     return pValue;
}