//////////////////////////////////////////////////////////////////////////////////////
//                                                                                  //
//      File        : main.cpp                                                      //
//      Version     : 0.1                                                           //
//      Initial     : 17 June 2015                                                  //
//      Author      : Dany Brugman                                                  //
//      Comment     : CANbus module analog sensor                                   //
//                                                                                  //
//                                                                                  //
//      Changelog   :                                                               //
//      Date:           Name:       Comment:                                        //
//      19/06/2015      DNB         First version                                   //
//                                                                                  //
//////////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////////
// includes                                                                         //
//////////////////////////////////////////////////////////////////////////////////////
#include "mbed.h"
#include "PinDetect.h"
#include "sensor.h"

//////////////////////////////////////////////////////////////////////////////////////
// device ID                                                                        //
// CAN module ultrasonic heightsensor port side define HEIGHT_PORT                  //
// CAN module ultrasonic heightsensor starboard side define HEIGHT_STARB            //
//////////////////////////////////////////////////////////////////////////////////////
#define HEIGHT_PORT
//////////////////////////////////////////////////////////////////////////////////////
// defines                                                                          //
////////////////////////////////////////////////////////////////////////////////////// 
#ifdef HEIGHT_PORT
    #define DEVICE_ID   201    
    #define REQ_STATUS  2003
#endif  
#ifdef HEIGHT_STARB
    #define DEVICE_ID   202  
    #define REQ_STATUS  2004
#endif 

//////////////////////////////////////////////////////////////////////////////////////
//                                                                                  //
////////////////////////////////////////////////////////////////////////////////////// 


//////////////////////////////////////////////////////////////////////////////////////
// interrupts                                                                       //
//////////////////////////////////////////////////////////////////////////////////////
Ticker  ticker;
Ticker  tActiveLedOn;
Ticker  tled2on;
Ticker  tReadSensor;

Timeout tActiveLedOff;
Timeout tled2off;

//////////////////////////////////////////////////////////////////////////////////////
// port declaration                                                                 //
//////////////////////////////////////////////////////////////////////////////////////
DigitalOut Led1(LED1);
DigitalOut Led2(LED2);
DigitalOut Led4(LED4);

AnalogIn sensorPort(p19);
Sensor sHeightSensor;
CAN CANBus(p30, p29);

Serial debug(USBTX, USBRX);

//////////////////////////////////////////////////////////////////////////////////////
// global variables                                                                 //
//////////////////////////////////////////////////////////////////////////////////////
char counter = 0;
char cMessage, cStatus;

int i;

float fValue, fDistance;


//////////////////////////////////////////////////////////////////////////////////////
// functions declarations                                                           //
//////////////////////////////////////////////////////////////////////////////////////



//////////////////////////////////////////////////////////////////////////////////////
// functions                                                                        //
//////////////////////////////////////////////////////////////////////////////////////


 
void send() 
{
    if(CANBus.write(CANMessage(1226, &counter, 1))) 
    {
        counter++;
    } 
}


//////////////////////////////////////////////////////////////////////////////////////
// Blink functions                                                                  //
//////////////////////////////////////////////////////////////////////////////////////
void tActiveLedOff_cb(void) 
{
    Led1 = 0;
}
 
void tActiveLedOn_cb(void) 
{
    Led1 = 1;
    tActiveLedOff.detach();
    tActiveLedOff.attach(&tActiveLedOff_cb, 0.05);
}

void tled2off_cb(void) 
{
    Led2 = 0;
}
 
void tled2on_cb(void) 
{
    Led2 = 1;
    tled2off.detach();
    tled2off.attach(&tled2off_cb, 0.05);
}

void tReadSensor_cb(void)
{
    sHeightSensor.vMeasureHeight();
    Led4 = !Led4;
}

//////////////////////////////////////////////////////////////////////////////////////
// main loop                                                                        //
//////////////////////////////////////////////////////////////////////////////////////
int main() {
    debug.baud(115200);
    debug.printf("\033[2J");
    debug.printf("\033[9;10fDevice ID:%i\r\n", DEVICE_ID);
    
    Led1 = 1;
    Led2 = 1;
//////////////////////////////////////////////////////////////////////////////////////
// schedule led events                                                              //
//////////////////////////////////////////////////////////////////////////////////////    
    tActiveLedOff.attach(&tActiveLedOn_cb, 0.05);
    tActiveLedOn.attach(&tActiveLedOn_cb, 2);
    tled2off.attach(&tled2on_cb, 0.05);
    tled2on.attach(&tled2on_cb, 1);
    tReadSensor.attach(&tReadSensor_cb, 0.09);        // call sensor read approx. 11 times/sec.

    
    CANBus.frequency(250000);
    CANMessage msg;
    
    while(1) 
    { 
        if(CANBus.read(msg))
        {
            switch(msg.id)
            {   // Send system status if MainModule requests
                case REQ_STATUS:
                            cStatus = 0xFF;                                     // OK
                            if(msg.data[0] == 00) CANBus.write(CANMessage(DEVICE_ID, &cStatus, 1));
                            wait_us(100);
                            break;
                // process stepper data direction/steps            
                case DEVICE_ID:
                            if(msg.data[0] == 0xff) 
                            {
                                sHeightSensor.setClearToSend(true);
                                debug.printf("sensor clear");
                                //tActiveLedOn.attach(&tActiveLedOn_cb, 0.5);   
                            }
                            else
                            {
                                sHeightSensor.setClearToSend(false);
                                debug.printf("sensor stop send");
                            }
                            //cStatus = 0xFF;
                            //CANBus.write(CANMessage(DEVICE_ID, &cStatus, 1));   // reply message received and executed
                            //tActiveLedOn.attach(&tActiveLedOn_cb, 2);                     // indicate active
                            break;
                
                // just dump received message (debug)
                default:    
                            debug.printf("Message id: %d\r\n", msg.id);
                            debug.printf("Message length: %d\r\n", msg.len);
                            for (i=0; i < msg.len; i++)
                            {
                                debug.printf("Message %d received: %d\r\n", i, msg.data[i]);
                            }
                            break;
            }//end switch
        }// end if
        
        wait(0.09);
    }
}

//////////////////////////////////////////////////////////////////////////////////////
// EOF                                                                              //
//////////////////////////////////////////////////////////////////////////////////////

