
#include "SensorData.h"


#define UART3_tx PTC17
#define UART3_rx PTC16


SensorData::SensorData(): s_com(UART3_tx, UART3_rx),
    pc(USBTX, USBRX),
    i2c(PTE25, PTE24),
    acc(i2c, FXOS8700CQ_SLAVE_ADDR1),
    mag(i2c, FXOS8700CQ_SLAVE_ADDR1)
{

}


void SensorData::run()
{
    pc.printf("hey");
    //initialise();
    if (s_com.readable()) 
    {
        stringstream ss;
        ss << readData() << sensor_data();
        alldata = ss.str();
        pc.printf(alldata.c_str());
    }
}

void SensorData::initialise()
{
    acc.enable(); //start accelerometer
    mag.enable();
    pc.baud(115200);
}

string SensorData::readData()
{
    char rca1[128];
    s_com.scanf("%s",rca1);
    //Throw away first sentence
    memset(rca1, 0, sizeof(rca1));
    //Try again
    s_com.scanf("%s",rca1);
    string rca2(rca1);
    //rca2 += "\n";
   // log_data(rca2);
    printf(rca2.c_str());
    gpsdata = rca2;
    return rca2;
}

string SensorData::sensor_data()
{
    stringstream ss;
    
    //get mag+accel data
    motion_data_units_t acc_data, mag_data;

    acc.getAxis(acc_data);
    mag.getAxis(mag_data);
       
        ss << "ACC: " << acc_data.x << "," << acc_data.y << "," << acc_data.z 
            << "MAG: " << mag_data.x << "," << mag_data.y << "," << mag_data.z << "\n";
            
    sensordata = ss.str();
    
    
    return ss.str();
}

string SensorData::getDataString()
{
    return alldata;
}