//#include "mbed.h"
//#include <string>
//#include "FXOS8700Q.h"
//#include "SDFileSystem.h"

#include "SensorData.h"


DigitalOut led(LED1);

#define UART3_tx PTC17
#define UART3_rx PTC16
//
//#define UART3_tx D8
//#define UART3_rx D2


SensorData mySensor;
//
//int main()
//{
//
//
//    printf("Hello World !\n");
//
//    while(1)
//    {
//        mySensor.run();
//    }
//
//}



SensorData::SensorData(): sd(PTE3, PTE1, PTE2, PTE4, "sd"),
    s_com(UART3_tx, UART3_rx),
    acc(i2c, FXOS8700CQ_SLAVE_ADDR1),
    mag(i2c, FXOS8700CQ_SLAVE_ADDR1)
{

}


void SensorData::run()
{
    while (s_com.readable()) {
        readData();
        sensor_data();
    }
}

void SensorData::initialise()
{

    acc.enable(); //start accelerometer
    mag.enable();

    fp = fopen("/sd/sensors.txt", "r");
    if (fp != NULL) {
        fclose(fp);
        remove("/sd/sensors.txt");
        //pc.printf("Remove an existing file with the same name \n");
    }
}

void SensorData::readData()
{
    s_com.scanf("%s",rca1);
    string rca2(rca1);
    rca2 += "\n";
    log_data(rca2);
    printf(rca2.c_str());
}

void SensorData::sensor_data()
{

    //get mag+accel data
    motion_data_units_t acc_data, mag_data;

    acc.getAxis(acc_data);
    mag.getAxis(mag_data);
//    pc.printf("\rACC: X=%1.4ff Y=%1.4ff Z=%1.4ff  ", acc_data.x, acc_data.y, acc_data.z);
//    pc.printf("    MAG: X=%4.1ff Y=%4.1ff Z=%4.1ff \r\n", mag_data.x, mag_data.y, mag_data.z);
//    data = ("ACC: "+ acc_data.x + ", "+ acc_data.y + ", " + acc_data.z  + "\n" +
//            "MAG: " + mag_data.x + ", " + mag_data.y + ", " + mag_data.z + "\n");
    data = "helloworld!\n"; //test
    log_data(data);

//    wait(0.5);

}


void SensorData::log_data(string dataToLog)
{

    // printf("\nWriting data to the sd card \n");
    fp = fopen("/sd/sensors.txt", "w");
    if (fp == NULL) {
        //pc.printf("Unable to write the file \n");
    } else {
        fprintf(fp, dataToLog.c_str());
        fclose(fp);
        //pc.printf("File successfully written! \n");
    }

}

string SensorData::getDataString()
{
    return data;
}