#include "mbed.h"
#include <string>
#include "FXOS8700Q.h"
#include "SDFileSystem.h"

I2C i2c(PTE25, PTE24);

class SensorData
{

public:
    //Constructor
    SensorData();
    
    void initialise();
    
    void run();
    
    //Read in serial line and send it to log_data
    void readData();
    
    //Read in accel and mag data
    void sensor_data();
    
    //Logs data to /sd/sensors.txt
    void log_data(string data);
    
    string getDataString();


private:
   // Serial s_com(UART3_tx, UART3_rx); // tx, rx read gps in

    FILE *fp;
    SDFileSystem sd; // MOSI, MISO, SCK, CS
    Serial s_com; // tx, rx read gps in
    FXOS8700QAccelerometer acc;  //access accelerometer
    FXOS8700QMagnetometer mag;

    char rca1[128];
//string rca2;
    string data;



};