#include "mbed.h"
#include "TinyGPSPlus.h"
//#include "SDFileSystem.h"
#include "FXOS8700Q.h"

//code in this program does the following:
//set up LoRa connection
//retreives the GPS data from the UBLOX module
//collect accellerometer and mag data from onboard chip
//log data on board SD
//sends the GPS + time via LoRa module

void data_logger();
void send_data();
void sensor_data();
void get_gps();
void lora_setup();

RawSerial s_com(PTC17, PTC16); // tx, rx read gps in
Serial pc(USBTX, USBRX); // tx, rx


TinyGPSPlus gps;
bool flag= false;
double latitude, longitude;
//String data;
//data="";
Timer t;
int data_time=0;
I2C i2c(PTE25, PTE24); 
FXOS8700QAccelerometer acc(i2c, FXOS8700CQ_SLAVE_ADDR1);  //access accelerometer 
FXOS8700QMagnetometer mag(i2c, FXOS8700CQ_SLAVE_ADDR1);   //access magnetometer
DigitalOut led1(LED1); //use for debugging 

int main(){
    //set up LoRa stuff
    //get current time (millis)
    //run gps method
    //get sensor data
    //call send data
    //log data
    
    t.start();   //start the timer object
    s_com.baud(9600); //set baud rate for serial read
    acc.enable(); //start accelerometer
    mag.enable(); //start magnetometer
    while(true){
        //sensor_data(); 
        get_gps();   
    }
}

void lora_setup(){
    //set up LoRa connection here 
}


void get_gps(){
//    //retreive gps data from module
    //printf("In get_gps\n");
    while(!flag){
        if(s_com.readable()) {
           // pc.putc(s_com.getc());
            flag = gps.encode(s_com.getc());
        } 
        
       // printf("youre stuck here forever");
    }
    //printf("enemy spotted \n");
    
    latitude = gps.location.lat();
    longitude = gps.location.lng();
    
    data_time = t.read_ms();
    //data = (string(latitude)+","+string(longitude)+","+string(data_time));
    printf("\r latitude %lf, longitude %lf \n", latitude, longitude);
    //send_gps(data);
    led1!=led1;
    wait(1000);
}


void send_data(){
    //send data via LoRa shield
}


void sensor_data(){
   
        //get mag+accel data
        motion_data_units_t acc_data, mag_data;
            
        acc.getAxis(acc_data);
        mag.getAxis(mag_data);
        data_time = t.read_ms();
        printf("ACC: X=%1.4ff Y=%1.4ff Z=%1.4ff \t MAG: X=%4.1ff Y=%4.1ff Z=%4.1ff\r\n", acc_data.x, acc_data.y, acc_data.z, mag_data.x, mag_data.y, mag_data.z);   
       // printf("TIME:"+ data_time+"\n"); //goes weird here
        wait(0.5);
     
}


void data_logger(){
    //log data onto on board SD
}