#include "mbed.h"
#include <string>
#include "FXOS8700Q.h"
#include "SDFileSystem.h"
/*------------------------------------------------------------------------------
Before to use this example, ensure that you an hyperterminal installed on your
computer. More info here: https://developer.mbed.org/handbook/Terminals

The default serial comm port uses the SERIAL_TX and SERIAL_RX pins (see their
definition in the PinNames.h file).

The default serial configuration in this case is 9600 bauds, 8-bit data, no parity

If you want to change the baudrate for example, you have to redeclare the
serial object in your code:

Serial pc(SERIAL_TX, SERIAL_RX);

Then, you can modify the baudrate and print like this:

pc.baud(115200);
pc.printf("Hello World !\n");
------------------------------------------------------------------------------*/

DigitalOut led(LED1);

#define UART3_tx PTC17
#define UART3_rx PTC16
//
//#define UART3_tx D8
//#define UART3_rx D2
Serial s_com(UART3_tx, UART3_rx); // tx, rx read gps in
SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd"); // MOSI, MISO, SCK, CS
FILE *fp;


void readData();
void sensor_data();
void log_data();

char rca1[128];
//string rca2;
string data;

int main()
{


    printf("Hello World !\n");
    acc.enable(); //start accelerometer
    mag.enable();
    
    
    fp = fopen("/sd/sensors.txt", "r");
    if (fp != NULL) {
        fclose(fp);
        remove("/sd/sensors.txt");
        //pc.printf("Remove an existing file with the same name \n");
    }

    while(1) {
        while (s_com.readable()) {
//            rca = s_com.getc();
//            printf("%c",rca);
            readData();
            sensor_data();

        }
    }
}

void readData()
{
    s_com.scanf("%s",rca1);
    string rca2(rca1);
    rca2 += "\n";
    log_data(rca2);
    printf(rca2.c_str());
}

void sensor_data()
{

    //get mag+accel data
    motion_data_units_t acc_data, mag_data;

    acc.getAxis(acc_data);
    mag.getAxis(mag_data);
    pc.printf("\rACC: X=%1.4ff Y=%1.4ff Z=%1.4ff  ", acc_data.x, acc_data.y, acc_data.z);
    pc.printf("    MAG: X=%4.1ff Y=%4.1ff Z=%4.1ff \r\n", mag_data.x, mag_data.y, mag_data.z);
    data = ("ACC: "+ acc_data.x + ", "+ acc_data.y + ", " + acc_data.z  + "\n" + 
            "MAG: " + mag_data.x + ", " + mag_data.y + ", " + mag_data.z + "\n");
    log_data(data);
    
//    wait(0.5);

}


void log_data(string data)
{

   // printf("\nWriting data to the sd card \n");
    fp = fopen("/sd/sensors.txt", "w");
    if (fp == NULL) {
        //pc.printf("Unable to write the file \n");
    } else {
        fprintf(fp, data);
        fclose(fp);
        //pc.printf("File successfully written! \n");
    }


}