#include "mbed.h"
#include "Matrix.h"
#include "USBSerial.h"
#include "Ticker.h"

//************************************* DEFINES *****************************************************

#define PI 3.1415926
#define Gravity 9.81

//***************************************************************************************************
//Current_Factors ------- Calibrated in A (Ampere)

#define Mot_curr_fac 0.00039021 // Factor for calculation
#define Mot_curr_off 10034.87   // Offset

#define Bra_curr_fac 0.00028048
#define Bra_curr_off 49481.61   // Offset

//***************************************************************************************************
//Voltage_Factors ------- Calibrated in V (Volt)

#define Mot_volt_fac 0.00050860 // Factor for calculation
#define Mot_volt_off 25.80      // Offset

#define Bra_volt_fac 0.00051015 // Factor for calculation
#define Bra_volt_off 33.63      // Offset

//***************************************************************************************************
//DMS_Factors ------- Calibrated in g (Gramm)

#define DMS_fac 0.019467    // Factor for calculation, gives back gramms
#define DMS_off 1629.33     // Offset

//*******LEVER********
#define Lever 0.05          // Length of lever

//***************************************************************************************************
//Outputs

DigitalOut Multiplex_select_A (p26);
DigitalOut Multiplex_select_B (p25);
DigitalOut File(LED1);

//***************************************************************************************************
//Inputs

AnalogIn Messkanal_X (p15);
AnalogIn Messkanal_Y (p16);
AnalogIn Messkanal_DMS (p17);

//***************************************************************************************************
//Interrupts

InterruptIn Lichtschranke(p29);

//***************************************************************************************************
//Ticker

Ticker Puls;

//***************************************************************************************************
//PWM

PwmOut Motor(p23);
PwmOut Bremse(p21);

//***************************************************************************************************
//Communication

Serial pc(USBTX, USBRX);

//***************************************************************************************************
//File System

LocalFileSystem local("local");

//***************************************************************************************************
//Variablen


volatile float  rps_old, rps, time_passed, Motorspannung, Bremsenspannung , Motorstrom, An_In_0, Bremsenstrom, Temperatur_0, Temperatur_1, Temperatur_2, DMS_Out;
volatile float P_Mech[2000], P_Elec[2000], PE, PM, eta;
float  counter = 0;


//***************************************************************************************************
//read sensors via multiplexer

void read_sensors()
{

    Multiplex_select_A = 0;
    Multiplex_select_B = 0;
    wait_us(1);
    An_In_0 = Messkanal_X.read_u16();
    Motorspannung = (Messkanal_Y.read_u16()-Mot_volt_off) * Mot_volt_fac;

    Multiplex_select_A = 1;
    wait_us(1);
    Temperatur_0 = Messkanal_X.read_u16();
    Motorstrom = (Messkanal_Y.read_u16() - Mot_curr_off) * Mot_curr_fac;

    Multiplex_select_A = 0;
    Multiplex_select_B = 1;
    wait_us(1);
    Temperatur_1 = Messkanal_X.read_u16();
    Bremsenspannung = (Messkanal_Y.read_u16() - Bra_volt_off) * Bra_curr_fac;

    Multiplex_select_A = 1;
    wait_us(1);
    Temperatur_2 = Messkanal_X.read_u16();
    Bremsenstrom = (Messkanal_Y.read_u16() - Bra_curr_off) * Bra_curr_fac;

    DMS_Out = (Messkanal_DMS.read_u16() - DMS_off) * DMS_fac;

}

//***************************************************************************************************
//Safety Circuit

int safety()
{
    int Temp_max;
    read_sensors();

    if( (Temperatur_0 < Temp_max) && (Temperatur_1 < Temp_max) && (Temperatur_2 < Temp_max))
        return(0);
    else
        return(1);
}

//***************************************************************************************************
//Checkup @ Start

int checkup()
{
    return(1);
}

//***************************************************************************************************
//Increase Counter to get rpm

void rpm_counter()
{
    counter++;
}

//***************************************************************************************************
//send values

void send_data(void)
{
    /*
        pc.printf(" [Temperatur1, Motorspannung]; 0 %5.2f deg; 1 %5.2f V;", Temperatur_0, Motorspannung);
        pc.printf(" [Temperatur2, Motorstrom]; 0 %5.2f deg; 1 %5.2f A;", Temperatur_1, Motorstrom);
        pc.printf(" [Temperatur3, Bremsenspannung]; 0 %5.2f deg; 1 %5.2f V;", Temperatur_2, Bremsenspannung);
        pc.printf(" [Aux, Bremsenstrom]; 0 %5.2f ; 1 %5.2f ;", An_In_0, Bremsenstrom);
        pc.printf(" [DMS-Kanal]; 0 %5.2f ;", DMS_Out);
        pc.printf(" [Temp_1, Temp_2]; %5.2f deg; %5.2f deg;", Temperatur_0, Temperatur_1);
        pc.printf(" [Temp_3, Analog_0; %5.2f deg; %5.2f deg;", Temperatur_2, An_In_0);
    */
    pc.printf(" [Motorstrom, Motorspannung]; %5.2f A ; %5.2f A ;", Motorstrom, Motorspannung);
    pc.printf(" [Bremsenstrom, Bremsenspannung]; %5.2f V ; %5.2f V ;", Bremsenstrom, Bremsenspannung);
    pc.printf(" [Kraft]; %5.2f ;", DMS_Out);
    pc.printf(" [rps]; %5.2f ;", rps);
    pc.printf(" [P_Mech, P_Elec]; %5.2f W ; %5.2f W ;", PM, PE );
    pc.printf(" [rpm]; %5.2f ;", rps*60);
    pc.printf(" [eta]; %5.2f ;", eta);
    pc.printf(" \r\n\r\n");
//    wait_ms(5);
}

//***************************************************************************************************
//calc rpm

void calc_rps()
{
    rps = counter/5;
    counter=0;
    rps_old = rps;
}


//***************************************************************************************************
// MAIN:

int main(void)
{
//********************* VARIABLEN *****************************


    bool lock = 0;
//
    time_passed=0;
    Motor.period_us(200);
    Bremse.period_us(200);

    Motor.pulsewidth_us(100);
    Bremse.pulsewidth_us(193);
    
//    Matrix Values(1,4);
    File=0;
    Lichtschranke.fall(&rpm_counter);          // Call function rpm_counter
    Puls.attach(&calc_rps, 1.0);
    wait(3);
    //FILE *fp = fopen("/local/Values.txt", "w");
   // fprintf(fp, "Motorstrom [A], Motorspannung [V], Bremsenstrom [A], Bremsenspannung [V], Kraft [g], Umdrehungen [1/s] \r\n");
    
//************************ MAIN ********************************


    while(1) {


        
        for (int i = 0; i<2000; i++) {
            read_sensors();
            P_Elec[i] = Motorstrom * Motorspannung;
            P_Mech[i] = ((DMS_Out / 1000) * Lever * Gravity * 2 * PI * rps);
        }

        for (int i = 0; i<2000; i++) {
            PE = P_Elec[i] + PE;
            PM = P_Mech[i] + PM;
        }
        PE = PE / 2000;
        PM = PM / 2000;
        eta = PM / PE;
        send_data();

        /*
        wait_ms(500);
        
        if(((rps - rps_old) < 1) && lock) {
            lock = 0;
            File = 1;
            fprintf(fp, "\r\n");
            
            for (int b=0; b<1000; b++) {
                read_sensors();
                File = !File;
                fprintf(fp, "%5.2f; %5.2f; ", Motorstrom, Motorspannung);
                fprintf(fp, "%5.2f; %5.2f; ", Bremsenstrom, Bremsenspannung);
                fprintf(fp, "%5.2f; %5.2f; ", DMS_Out, rps);
                fprintf(fp, "\r\n");
                File = !File;
            }
            fclose(fp);
            File = 0;
            Motor.pulsewidth_us(200);
            
        }
        */
       


//********************* Messprozedur ****************************
//*********************

    }

}