#include "mbed.h"

//***************************************************************************************************
//Outputs

DigitalOut Multiplex_select_0 (p25);
DigitalOut Multiplex_select_1 (p26);
DigitalOut Myled (LED1);

//DigitalOut timetest_0 (p30);
//DigitalOut timetest_1 (p29);

//BusOut    unused(p18);

//***************************************************************************************************
//Inputs


AnalogIn Messkanal_0 (p15);
AnalogIn Messkanal_1 (p16);

AnalogIn DMS_Kanal (p17);

//***************************************************************************************************
//Communication

Serial pc(USBTX, USBRX);


volatile float  Motorspannung, Bremsenspannung , Motorstrom, Aux, Bremsenstrom, Temperatur_1, Temperatur_2, Temperatur_3, DMS_Out, DMS_Skalierung;


//***************************************************************************************************
//read sensors via multiplexer

void interr_read_sensors()
{

    int  Messwert_0 = 0, Messwert_1 = 0;

    Multiplex_select_0 = 0, Multiplex_select_1 = 0;

    //Selection of Multiplexer states

    for (int i=0; i<=4; i++) {
        //while(i<=4) {

        Multiplex_select_0 = i&0x01;
        Multiplex_select_1 = (i>>1)&0x01;
        wait(0.001);

        Messwert_0 = Messkanal_0.read_u16();
        Messwert_1 = Messkanal_1.read_u16();

        switch(i) {
            case 0: {
                Multiplex_select_0 = 0;
                Multiplex_select_1 = 0;
                wait(0.001);
                Temperatur_1 = Messwert_0 ;
                Motorspannung = Messwert_1; //* 0.000515 - 0.05 ; Gute Näherung von 2- ~23V. Dannach zu niedrig.Z-Diode
                break;
            }

            case 1: {
                Multiplex_select_0 = 1;
                Multiplex_select_1 = 0;
                wait(0.001);
                Temperatur_2 = Messwert_0  ;
                Motorstrom = Messwert_1; //* 0.000396 - 4.15;
                break;
            }

            case 2: {
                Multiplex_select_0 = 0;
                Multiplex_select_1 = 1;
                wait(0.001);
                Temperatur_3 = Messwert_0;
                Bremsenspannung = Messwert_1; //* 0.000515 - 0.05;Gute Näherung von 2- ~23V. Dannach zu niedrig.Z-Diode
                break;
            }

            case 3: {
                Multiplex_select_0 = 1;
                Multiplex_select_1 = 1;
                wait(0.001);
                Aux = Messwert_0; // 1629;
                Bremsenstrom = Messwert_1; //* 0.00032 - 15.8;
                break;
            }


        }

    }

}


//***************************************************************************************************
// MAIN:

int main(void)
{

DMS_Skalierung = 1;

    while(true) {



        interr_read_sensors();
        
        DMS_Out = DMS_Kanal.read_u16()*DMS_Skalierung;


        pc.printf(" [Temperatur1, Motorspannung]; 0 %5.2f deg; 1 %5.2f V;", Temperatur_1, Motorspannung);
        pc.printf(" [Temperatur2, Motorstrom]; 0 %5.2f deg; 1 %5.2f A;", Temperatur_2, Motorstrom);
        pc.printf(" [Temperatur3, Bremsenspannung]; 0 %5.2f deg; 1 %5.2f V;", Temperatur_3, Bremsenspannung);
        pc.printf(" [Aux, Bremsenstrom]; 0 %5.2f ; 1 %5.2f ;", Aux, Bremsenstrom);
        pc.printf(" [DMS-Kanal]; 0 %5.2f ;", DMS_Out);
        pc.printf(" \r\n\r\n");

        wait(1);

    }
}