#include "mbed.h"


#define PI 3.1415926
#define DMS_torque_factor 0.3

//*******************************************
//****INPUTS*********************************

PwmOut Motor_Fet(p22);

DigitalIn Light_Barrier(p14);

DigitalOut Fet_Brake(p21);
DigitalOut Mux_0(p15);
DigitalOut Mux_1(p16);

AnalogIn DMS_Value(p17);

//*******************************************
//****COMM***********************************

Serial pc(USBTX, USBRX); // tx, rx

//*******************************************
//****Timer**********************************

Timer Light;

void read_sensors(void);

//****************************************************
//****MAIN-FUNCTION***********************************

int main()
{
    bool lock = 0;
    int diff_rpm = 0, spec_rpm = 0, time_passed = 0, DMS_Value = 0;
    int Motor_C = 0, Motor_V = 0, Brake_C = 0, Brake_V = 0;
    int Temp_0 = 0, Temp_1 = 0, Temp_2 = 0, Aux = 0;
    float torque = 0, Mech_Power = 0 , act_rps = 0, act_rpm = 0;
    float Elec_Power = 0;
    
    
    
    
    
    Motor_Fet.period_us(20000);         //20ms period servo signal
    Motor_Fet.pulsewidth_us(900);       //900us startup value

    
    //**************************Main-Circle*******************************
   
    while(1) 
    {
        //**************************LIGHTBARRIER*******************************
            
                                                    //Light_Barrier_Low = Trigger
        if (!Light_Barrier)                         //Detects Falling Edge of the Light_Barrier
        {   
            
            if (!lock)                              //Asures First Run since detected Edge
            {   
                Light.stop();                       //Stops Timer
                time_passed = Light.read_us();       
                Light.start();                      //Starts Timer        
                lock = 1;                           //Asures just one counter-increase per Falling Edge -> Locks timer
            }         
        }
        else
        lock = 0;                                   //Unlocks timer-lock with High-Level of Light_Barrier
        
        //**************************LIGHTBARRIER*******************************
        
        
        //**************************RPS****************************************
        
        act_rps =  (1 / time_passed) * 1E06;
        act_rpm = act_rps * 60;
        
        //**************************RPS****************************************
    
    
        //**************************Specified-rpm******************************
        
        if (pc.readable())              //Just call if theres a value...
        {  
            scanf("%i", &spec_rpm);
        }    
              
        //**************************Specified-rpm******************************
        
        //**************************Diff-rpm***********************************
        
        diff_rpm = spec_rpm - (time_passed * 0.0036);
        
        //**************************Diff-rpm***********************************
        
        
        //**************************Set-PWM************************************
        
        Motor_Fet.pulsewidth_us();
        
        //**************************Set-PWM************************************
        
        
        //**************************Read-Sensors*******************************
        
        read_sensors();
        
        //**************************Read-Sensors*******************************
        
        
        //**************************DMS****************************************
        
        torque = DMS_Value * DMS_torque_factor;                 //Calculating torque
    
        //**************************DMS****************************************
        
        //**************************Mech-Power*********************************
        
        Mech_Power = torque * 2 * PI * act_rps;                 //Calculating Mechanical Power
        
        //**************************Mech-Power*********************************
        
        //**************************Elec-Power*********************************
        
        Elec_Power = Motor_V * Motor_C;
        
        //**************************Elec-Power*********************************
        
        
    }
}

void read_sensors(void)
{
    int  Messwert_0 = 0, Messwert_1 = 0;
 
    Mux_0 = 0, Mux_1 = 0;
 
    //Selection of Multiplexer states
 
    for (int i=0; i<=4; i++) {
        
 
        Mux_0 = i&0x01;
        Mux_1 = (i>>1)&0x01;
        wait(0.00001);
 
        Messwert_0 = Messkanal_0.read_u16();
        Messwert_1 = Messkanal_1.read_u16();
 
        switch(i) {
            case 0: {
                Temperatur_1 = Messwert_0 ;
                Motorspannung = Messwert_1 * 0.000515 - 0.05 ; //Gute Näherung von 2- ~23V. Dannach zu niedrig.Z-Diode
                break;
            }
 
            case 1: {
                Temperatur_2 = Messwert_0  ;
                Motorstrom = Messwert_1 * 0.000396 - 4.15;//
                break;
            }
 
            case 2: {
                Temperatur_3 = Messwert_0;
                Bremsenspannung = Messwert_1 * 0.000515 - 0.05;//Gute Näherung von 2- ~23V. Dannach zu niedrig.Z-Diode
                break;
            }
 
            case 3: {
                Aux = Messwert_0 / 1629;
                Bremsenstrom = Messwert_1; //* 0.00032 - 15.8;
                break;
            }
 
 
        }
 
    }
}
    