
#include "mbed.h"
#include "EthernetInterface.h"
#include "USBSerial.h"


Serial pc(USBTX, USBRX);

int main()
{

    EthernetInterface eth;

    int err = eth.init();
    if (err)
        pc.printf("eth.init() failed. (%d)\n\r", err);
    else
        pc.printf("eth.init() successful.\n\r");

    err = eth.connect();
    if (err)
        pc.printf("eth.connect() failed. (%d)\n\r", err);
    else
        pc.printf("eth.connect() successful.\n\r");

    char *ip_address = eth.getIPAddress();
    pc.printf("IP-Address: %s\n\r", ip_address);

    err = udp.init();
    if (err)
        pc.printf("udp.init() failed. (%d)\n\r", err);
    else
        pc.printf("udp.init() successful.\n\r");

    err = udp_dest.set_address("192.168.0.183", 1234);
    if (err)
        pc.printf("udp_dest.set_address() failed. (%d)\n\r", err);
    else
        pc.printf("udp_dest.set_address() successful.\n\r");


}