#include "PS4.h"

PS4::PS4(RawSerial *i)
{
    serial = i;
    serial->baud(115200);
    for(int i=0; i<16; i++) {
        BUTTON_OLD[i] = 0;
        BUTTON_NEW[i] = 0;
    }
}

int PS4::getPress( int button,bool finger)
{
    if (button >= 1 && button <= 16) return BUTTON_NEW[button - 1];
    serial->putc((finger << 7) + button);
    if (button == 0) {
        for (int wait = 0; wait < 2000; wait++) if (serial->readable() == 1) return serial->getc();
        return 0; // PS4通信成功 -> 1 失敗 -> 0
    }
    if (button == 0xFF) {
        for (int wait = 0; serial->readable() == 0; wait++) {
            if (wait > 2000) {
                for(int i=0; i<16; i++) BUTTON_NEW[i] = BUTTON_OLD[i] = 0;
                return 0;
            }
        }
        char getData = serial->getc();
        for (int i = 0; i<16; i++) BUTTON_OLD[i] = BUTTON_NEW[i];
        BUTTON_NEW[UP - 1] = (getData >> 7) & 0x01;
        BUTTON_NEW[RIGHT - 1] = (getData >> 6) & 0x01;
        BUTTON_NEW[DOWN - 1] = (getData >> 5) & 0x01;
        BUTTON_NEW[LEFT - 1] = (getData >> 4) & 0x01;
        BUTTON_NEW[TRIANGLE - 1] = (getData >> 3) & 0x01;
        BUTTON_NEW[CIRCLE - 1] = (getData >> 2) & 0x01;
        BUTTON_NEW[CROSS - 1] = (getData >> 1) & 0x01;
        BUTTON_NEW[SQUARE - 1] = (getData >> 0) & 0x01;
        for (int wait = 0; serial->readable() == 0; wait++) {
            if (wait > 2000) {
                for(int i=8; i<16; i++) BUTTON_NEW[i] = BUTTON_OLD[i] = 0;
                return 0;
            }
        }
        getData = serial->getc();
        BUTTON_NEW[L1 - 1] = (getData >> 7) & 0x01;
        BUTTON_NEW[R1 - 1] = (getData >> 6) & 0x01;
        BUTTON_NEW[SHARE - 1] = (getData >> 5) & 0x01;
        BUTTON_NEW[OPTIONS - 1] = (getData >> 4) & 0x01;
        BUTTON_NEW[L3 - 1] = (getData >> 3) & 0x01;
        BUTTON_NEW[R3 - 1] = (getData >> 2) & 0x01;
        BUTTON_NEW[PS - 1] = (getData >> 1) & 0x01;
        BUTTON_NEW[TOUCHPAD - 1] = (getData >> 0) & 0x01;
    }
    if (button >= 17 && button <= 22) {
        for (int wait = 0; serial->readable() == 0; wait++) {
            if (wait > 2000) {
                if(button >= 19 && button <= 22) return 127;
                else return 0;
            }
        }
        char getData = serial->getc();
        return getData;
    } else if (button >= 23 && button <= 26) {
        for (int wait = 0; serial->readable() == 0; wait++) if (wait > 2000) return 0;
        char getData = serial->getc();
        int getTouchPad = getData << 8;
        for (int wait = 0; serial->readable() == 0; wait++) if (wait > 2000) return 0;
        getTouchPad += serial->getc();
        return getTouchPad;
    }
    return 0;
}

int PS4::getClick( int button ,bool mode)
{
    if(button >= 1 && button <= 16) return ((BUTTON_NEW[button - 1] & !BUTTON_OLD[button - 1]) & mode) + ((!BUTTON_NEW[button - 1] & BUTTON_OLD[button - 1]) & !mode);
    return -1;
}

void PS4::disConnect() {
    serial->putc(0x20);
}